/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;

public class PlaySoundPacket {
    private final BlockPos pos;
    private final SoundEvent sound;
    private final SoundSource source;
    private final float volume;
    private final float pitch;

    public PlaySoundPacket(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.pos = pos;
        this.sound = sound;
        this.source = source;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130085_(this.sound.m_11660_());
        buffer.m_130068_((Enum)this.source);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
    }

    public static PlaySoundPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_());
        SoundSource source = (SoundSource)buffer.m_130066_(SoundSource.class);
        float volume = buffer.readFloat();
        float pitch = buffer.readFloat();
        return new PlaySoundPacket(pos, sound, source, volume, pitch);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft.m_91087_().f_91073_.m_245747_(this.pos, this.sound, this.source, this.volume, this.pitch, false);
            }
        });
        context.get().setPacketHandled(true);
    }
}

