/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class TableHelper {
    private TableHelper() {
        throw new IllegalStateException("Cannot instantiate singleton " + this.getClass().getName());
    }

    public static LuaException badKey(String key, String expected, @Nullable Object actual) {
        return TableHelper.badKey(key, expected, LuaValues.getType(actual));
    }

    public static LuaException badKey(String key, String expected, String actual) {
        return new LuaException("bad field '" + key + "' (" + expected + " expected, got " + actual + ")");
    }

    public static double getNumberField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static int getIntField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static double getRealField(Map<?, ?> table, String key) throws LuaException {
        return TableHelper.checkReal(key, TableHelper.getNumberField(table, key));
    }

    public static boolean getBooleanField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw TableHelper.badKey(key, "boolean", value);
    }

    public static String getStringField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        throw TableHelper.badKey(key, "string", value);
    }

    public static Map<Object, Object> getTableField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value instanceof Map) {
            return (Map)value;
        }
        throw TableHelper.badKey(key, "table", value);
    }

    public static double optNumberField(Map<?, ?> table, String key, double def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static int optIntField(Map<?, ?> table, String key, int def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return (int)((Number)value).longValue();
        }
        throw TableHelper.badKey(key, "number", value);
    }

    public static Optional<Double> optRealField(Map<?, ?> table, String key) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(TableHelper.getRealField(table, key));
    }

    public static double optRealField(Map<?, ?> table, String key, double def) throws LuaException {
        return TableHelper.checkReal(key, TableHelper.optNumberField(table, key, def));
    }

    public static boolean optBooleanField(Map<?, ?> table, String key, boolean def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw TableHelper.badKey(key, "boolean", value);
    }

    public static @Nullable String optStringField(Map<?, ?> table, String key, @Nullable String def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw TableHelper.badKey(key, "string", value);
    }

    public static Map<Object, Object> optTableField(Map<?, ?> table, String key, Map<Object, Object> def) throws LuaException {
        Object value = table.get(key);
        if (value == null) {
            return def;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw TableHelper.badKey(key, "table", value);
    }

    private static double checkReal(String key, double value) throws LuaException {
        if (!Double.isFinite(value)) {
            throw TableHelper.badKey(key, "number", LuaValues.getNumericType(value));
        }
        return value;
    }
}

