/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.client.gui.widget.Sprite;
import li.cil.oc2.common.util.TextFormatUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public abstract class ImageButton
extends AbstractButton {
    private static final long PRESS_DURATION = 200L;
    private static final long TOOLTIP_DELAY = 250L;
    private final Sprite baseImage;
    private final Sprite pressedImage;
    private List<Component> tooltip = Collections.emptyList();
    private long lastPressedAt;
    private long hoveringStartedAt;

    protected ImageButton(int x, int y, int width, int height, Sprite baseImage, Sprite pressedImage) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.baseImage = baseImage;
        this.pressedImage = pressedImage;
    }

    public ImageButton withMessage(Component component) {
        this.m_93666_(component);
        return this;
    }

    public ImageButton withTooltip(Component ... components) {
        this.tooltip = Arrays.asList(components);
        for (int i = 1; i < this.tooltip.size(); ++i) {
            Component component = this.tooltip.get(i);
            this.tooltip.set(i, TextFormatUtils.withFormat(component, ChatFormatting.GRAY));
        }
        return this;
    }

    public void m_5691_() {
        this.lastPressedAt = System.currentTimeMillis();
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        Sprite background = this.baseImage;
        if (System.currentTimeMillis() - this.lastPressedAt < 200L) {
            background = this.pressedImage;
        }
        background.draw(graphics, this.f_93620_, this.f_93621_);
        if (!Objects.equals(this.m_6035_(), Component.m_237119_())) {
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.f_93620_ + this.f_93618_ / 2, this.f_93621_ + (this.f_93619_ - 8) / 2, this.getFGColor() | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
    }

    @Nullable
    public Tooltip m_278622_() {
        if (this.tooltip.stream().findFirst().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tooltip.size(); ++i) {
            builder.append(this.tooltip.get(i).getString()).append(i == this.tooltip.size() - 1 ? "" : "\n");
        }
        MutableComponent component = Component.m_237113_((String)builder.toString());
        return Tooltip.m_257550_((Component)component);
    }
}

