/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import li.cil.oc2.client.renderer.ModRenderType;
import li.cil.oc2.client.renderer.ProjectorDepthRenderer;
import li.cil.oc2.common.block.ProjectorBlock;
import li.cil.oc2.common.blockentity.ProjectorBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="oc2r", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    private static final int LIGHT_COLOR_NEAR = 0x22FFFFFF;
    private static final int LIGHT_COLOR_FAR = 0xFFFFFF;
    private static final int LENS_COLOR = -570425345;
    private static final int MISSING_ENERGY_COLOR = -285251994;
    private static final int LED_COLOR = -865695523;
    private static final float LENS_RIGHT = 0.25f;
    private static final float LENS_LEFT = 0.75f;
    private static final float LENS_BOTTOM = 0.25f;
    private static final float LENS_TOP = 0.75f;

    public ProjectorRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public boolean shouldRender(ProjectorBlockEntity projector, Vec3 position) {
        return !ProjectorDepthRenderer.isIsRenderingProjectorDepth() && super.m_142756_((BlockEntity)projector, position);
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity projector) {
        return true;
    }

    public void render(ProjectorBlockEntity projector, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        if (projector.isProjecting()) {
            stack.m_85836_();
            this.alignToFrontFace(projector, stack);
            if (projector.hasEnergy()) {
                if (ProjectorRenderer.canSeeProjectedImage(stack)) {
                    ProjectorDepthRenderer.addProjector(projector);
                }
                ProjectorRenderer.renderProjectorLight(stack, bufferSource);
            } else {
                ProjectorRenderer.renderMissingEnergyIndicator(stack, bufferSource);
            }
            stack.m_85849_();
        }
    }

    private static boolean canSeeProjectedImage(PoseStack stack) {
        Matrix4f matrix = stack.m_85850_().m_252922_();
        Vector4f lookDirection = new Vector4f(0.0f, 0.0f, -1.0f, 0.0f);
        lookDirection.mul((Matrix4fc)matrix);
        Vector4f relativePosition = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
        relativePosition.mul((Matrix4fc)matrix);
        return relativePosition.dot((Vector4fc)lookDirection) < 16.0f;
    }

    private void alignToFrontFace(ProjectorBlockEntity projector, PoseStack stack) {
        Direction blockFacing = (Direction)projector.m_58900_().m_61143_((Property)ProjectorBlock.f_54117_);
        Quaternionf rotation = Axis.f_252392_.m_252977_(blockFacing.m_122435_());
        stack.m_252880_(0.5f, 0.0f, 0.5f);
        stack.m_252781_(rotation);
    }

    private static void renderProjectorLight(PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85837_(-0.5, 0.0, 0.5);
        VertexConsumer consumer = bufferSource.m_6299_(ModRenderType.getProjectorLight());
        Matrix4f matrix = stack.m_85850_().m_252922_();
        float leftFar = 1.25f;
        float rightFar = -0.25f;
        float topFar = 1.5f;
        float bottomFar = 0.0625f;
        consumer.m_252986_(matrix, 1.25f, 1.5f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.75f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.25f, 0.75f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, -0.25f, 1.5f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 1.25f, 0.0625f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.25f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.25f, 0.25f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, -0.25f, 0.0625f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 1.25f, 1.5f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 1.25f, 0.0625f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.25f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.75f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, -0.25f, 1.5f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.25f, 0.75f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, 0.25f, 0.25f, 0.0f).m_193479_(0x22FFFFFF).m_5752_();
        consumer.m_252986_(matrix, -0.25f, 0.0625f, 1.0f).m_193479_(0xFFFFFF).m_5752_();
        ProjectorRenderer.renderLens(matrix, consumer, -570425345);
        ProjectorRenderer.renderLed(matrix, consumer);
    }

    private static void renderMissingEnergyIndicator(PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85837_(-0.5, 0.0, 0.5);
        VertexConsumer consumer = bufferSource.m_6299_(ModRenderType.getProjectorLight());
        Matrix4f matrix = stack.m_85850_().m_252922_();
        ProjectorRenderer.renderLens(matrix, consumer, -285251994);
        ProjectorRenderer.renderLed(matrix, consumer);
    }

    private static void renderLens(Matrix4f matrix, VertexConsumer consumer, int color) {
        float lensDepth = -0.0625f;
        consumer.m_252986_(matrix, 0.25f, 0.25f, -0.0625f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.25f, -0.0625f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, 0.75f, 0.75f, -0.0625f).m_193479_(color).m_5752_();
        consumer.m_252986_(matrix, 0.25f, 0.75f, -0.0625f).m_193479_(color).m_5752_();
    }

    private static void renderLed(Matrix4f matrix, VertexConsumer consumer) {
        float ledRight = 0.4375f;
        float ledLeft = 0.5625f;
        float ledBottom = 0.1875f;
        float ledTop = 0.25f;
        float ledDepth = -0.046875f;
        consumer.m_252986_(matrix, 0.4375f, 0.1875f, -0.046875f).m_193479_(-865695523).m_5752_();
        consumer.m_252986_(matrix, 0.5625f, 0.1875f, -0.046875f).m_193479_(-865695523).m_5752_();
        consumer.m_252986_(matrix, 0.5625f, 0.25f, -0.046875f).m_193479_(-865695523).m_5752_();
        consumer.m_252986_(matrix, 0.4375f, 0.25f, -0.046875f).m_193479_(-865695523).m_5752_();
    }
}

