/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.vm.item;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.bus.device.vm.item.AbstractNetworkInterfaceDevice;
import li.cil.oc2.common.inet.InternetAdapter;
import li.cil.oc2.common.inet.InternetConnection;
import li.cil.oc2.common.inet.InternetManagerImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class InternetCardDevice
extends AbstractNetworkInterfaceDevice {
    private static final Logger LOGGER = LogManager.getLogger();
    private InternetConnection internetConnection = null;
    private Tag internetAdapterState = null;

    public InternetCardDevice(ItemStack identity) {
        super(identity);
    }

    private void openInternetAccess() {
        LOGGER.debug("Connect internet card");
        this.closeInternetAccess();
        InternetAdapterImpl internetAdapter = new InternetAdapterImpl(this.getNetworkInterface());
        InternetManagerImpl.getInstance().ifPresent(internetManager -> {
            this.internetConnection = internetManager.connect(internetAdapter, this.internetAdapterState);
        });
    }

    private void closeInternetAccess() {
        if (this.internetConnection != null) {
            LOGGER.debug("Disconnect internet card");
            this.internetConnection.stop();
            this.internetConnection = null;
        }
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.internetAdapterState = tag.m_128423_("InternetAdapter");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        InternetConnection internetConnection = this.internetConnection;
        if (internetConnection != null) {
            internetConnection.saveAdapterState().ifPresent(adapterState -> {
                tag.m_128365_("InternetAdapter", adapterState);
                this.internetAdapterState = adapterState;
            });
        }
        return tag;
    }

    @Override
    public VMDeviceLoadResult mount(VMContext context) {
        VMDeviceLoadResult result = super.mount(context);
        this.openInternetAccess();
        return result;
    }

    @Override
    public void unmount() {
        super.unmount();
        this.closeInternetAccess();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private record InternetAdapterImpl(NetworkInterface networkInterface) implements InternetAdapter
    {
        @Override
        @Nullable
        public byte[] receiveEthernetFrame() {
            return this.networkInterface.readEthernetFrame();
        }

        @Override
        public void sendEthernetFrame(byte[] frame) {
            this.networkInterface.writeEthernetFrame(this.networkInterface, frame, 64);
        }
    }
}

