/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.integration;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import li.cil.oc2.api.imc.RPCMethodParameterTypeAdapter;
import li.cil.oc2.common.bus.device.rpc.RPCMethodParameterTypeAdapters;
import net.minecraft.Util;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IMC {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<String, Consumer<InterModComms.IMCMessage>> METHODS = (HashMap)Util.m_137537_(() -> {
        HashMap<String, Consumer<InterModComms.IMCMessage>> map = new HashMap<String, Consumer<InterModComms.IMCMessage>>();
        map.put("addRPCMethodParameterTypeAdapter", IMC::addRPCMethodParameterTypeAdapter);
        return map;
    });

    public static void initialize() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMC::handleIMCMessages);
    }

    private static void handleIMCMessages(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            Consumer<InterModComms.IMCMessage> method = METHODS.get(message.method());
            if (method != null) {
                method.accept((InterModComms.IMCMessage)message);
            } else {
                LOGGER.error("Received unknown IMC message [{}] from mod [{}], ignoring.", (Object)message.method(), (Object)message.senderModId());
            }
        });
    }

    private static void addRPCMethodParameterTypeAdapter(InterModComms.IMCMessage message) {
        IMC.getMessageParameter(message, RPCMethodParameterTypeAdapter.class).ifPresent(value -> {
            try {
                RPCMethodParameterTypeAdapters.addTypeAdapter(value);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Received invalid type adapter registration [{}] for type [{}] from mod [{}].", value.typeAdapter(), value.type(), (Object)message.senderModId());
            }
        });
    }

    private static <T> Optional<T> getMessageParameter(InterModComms.IMCMessage message, Class<T> type) {
        Object value = message.messageSupplier().get();
        if (type.isInstance(value)) {
            return Optional.of(value);
        }
        LOGGER.error("Received incompatible parameter [{}] for IMC message [{}] from mod [{}]. Expected type is [{}].", message.messageSupplier().get(), (Object)message.method(), (Object)message.senderModId(), type);
        return Optional.empty();
    }
}

