/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.client.rendering;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.rendering.forge.ColorHandlerRegistryImpl;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ColorHandlerRegistry {
    private ColorHandlerRegistry() {
    }

    public static void registerItemColors(ItemColor color, ItemLike ... items) {
        Supplier[] array = new Supplier[items.length];
        for (int i = 0; i < items.length; ++i) {
            ItemLike item = Objects.requireNonNull(items[i], "items[i] is null!");
            array[i] = () -> item;
        }
        ColorHandlerRegistry.registerItemColors(color, array);
    }

    public static void registerBlockColors(BlockColor color, Block ... blocks) {
        Supplier[] array = new Supplier[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            Block block = Objects.requireNonNull(blocks[i], "blocks[i] is null!");
            array[i] = () -> block;
        }
        ColorHandlerRegistry.registerBlockColors(color, array);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemColors(ItemColor color, Supplier<? extends ItemLike> ... items) {
        void var1_1;
        ColorHandlerRegistryImpl.registerItemColors(color, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColors(BlockColor color, Supplier<? extends Block> ... blocks) {
        void var1_1;
        ColorHandlerRegistryImpl.registerBlockColors(color, var1_1);
    }
}

