/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.mixin.BossHealthOverlayAccess;
import mcp.mobius.waila.mixin.GameNarratorAccess;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class TooltipRenderer {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static boolean started;
    private static String lastNarration;
    private static ITooltipComponent icon;
    private static int topOffset;
    public static int colonOffset;
    public static int colonWidth;
    public static State state;
    private static long lastFrame;
    @Nullable
    private static MainTarget framebuffer;
    private static int fbWidth;
    private static int fbHeight;

    public static void beginBuild(State state) {
        started = true;
        TooltipRenderer.state = state;
        TOOLTIP.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = Minecraft.m_91087_().f_91062_.m_92895_(": ");
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        ObjectListIterator objectListIterator = tooltip.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            TooltipRenderer.add(line);
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        if (line.tag != null) {
            TOOLTIP.setLine(line.tag, line);
        } else {
            TOOLTIP.add(line);
        }
        for (ITooltipComponent component : line.components) {
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipRenderer.icon = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static Rectangle endBuild() {
        Preconditions.checkState((boolean)started);
        if (state.fireEvent()) {
            for (IInstanceRegistry.Entry<IEventListener> listener : Registrar.get().eventListeners.get(Object.class)) {
                listener.instance().onHandleTooltip(TOOLTIP, ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            }
        }
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        TooltipRenderer.narrateObjectName(client);
        float scale = state.getScale();
        int fw = 0;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.calculateFixedWidth();
            fw = Math.max(fw, line.getFixedWidth());
        }
        int w = 0;
        int h = 0;
        ObjectListIterator iterator = TOOLTIP.iterator();
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            line.calculateDynamicWidth(fw);
            line.calculateHeight();
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            if (lineH <= 0) {
                iterator.remove();
                continue;
            }
            w = Math.max(w, lineW);
            h += lineH + 1;
        }
        if (h > 0) {
            --h;
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = Mth.m_184652_((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        Padding padding = Padding.INSTANCE;
        padding.set(0);
        state.getTheme().setPadding(padding);
        w += padding.left + padding.right;
        h = Math.max(h, icon.getHeight()) + padding.top + padding.bottom;
        int windowW = (int)((float)window.m_85445_() / scale);
        int windowH = (int)((float)window.m_85446_() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = state.getXAnchor();
        IWailaConfig.Overlay.Position.Align.Y anchorY = state.getYAnchor();
        IWailaConfig.Overlay.Position.Align.X alignX = state.getXAlign();
        IWailaConfig.Overlay.Position.Align.Y alignY = state.getYAlign();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)state.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)state.getY();
        if (!state.bossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(((BossHealthOverlayAccess)client.f_91065_.m_93090_()).wthit_events().size() * 19, window.m_85446_() / 3 + 2);
        }
        RECT.get().setRect(Mth.m_14107_((double)(x + 0.5)), Mth.m_14107_((double)(y + 0.5)), w, h);
        started = false;
        return RECT.get();
    }

    public static void resetState() {
        state = null;
    }

    public static void render(GuiGraphics ctx, float delta) {
        Minecraft client = Minecraft.m_91087_();
        if (WailaClient.showFps) {
            String fpsString = client.m_260875_() + " FPS";
            int x1 = client.f_91062_.m_92895_(fpsString) + 2;
            int n = client.m_91268_().m_85446_();
            Objects.requireNonNull(client.f_91062_);
            int y0 = n - 9 - 1;
            Objects.requireNonNull(client.f_91062_);
            int y1 = y0 + 9 + 2;
            ctx.m_280509_(0, y0, x1, y1, -1873784752);
            ctx.m_280056_(client.f_91062_, fpsString, 1, y0 + 1, 0xE0E0E0, false);
        }
        if (state == null || !state.render()) {
            return;
        }
        int fps = state.getFps();
        TooltipRenderer.render0(client, ctx, delta);
    }

    /*
     * WARNING - void declaration
     */
    private static void render0(Minecraft client, GuiGraphics ctx, float delta) {
        void var14_21;
        ProfilerFiller profiler = client.m_91307_();
        profiler.m_6180_("Waila Overlay");
        float scale = state.getScale();
        ctx.m_280168_().m_85836_();
        ctx.m_280168_().m_85841_(scale, scale, 1.0f);
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        if (state.fireEvent()) {
            EventCanceller canceller = EventCanceller.INSTANCE;
            canceller.setCanceled(false);
            for (IInstanceRegistry.Entry<IEventListener> listener : Registrar.get().eventListeners.get(Object.class)) {
                listener.instance().onBeforeTooltipRender(ctx, rect, ClientAccessor.INSTANCE, PluginConfig.CLIENT, canceller);
                if (!canceller.isCanceled()) continue;
                ctx.m_280168_().m_85849_();
                RenderSystem.enableDepthTest();
                RenderSystem.applyModelViewMatrix();
                profiler.m_7238_();
                return;
            }
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Padding padding = Padding.INSTANCE;
        if (state.getBackgroundAlpha() > 0) {
            state.getTheme().renderTooltipBackground(ctx, x, y, width, height, state.getBackgroundAlpha(), delta);
        }
        int textX = x + padding.left;
        int textY = y + padding.top + topOffset;
        if (icon.getWidth() > 0) {
            textX += icon.getWidth() + 3;
        }
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.render(ctx, textX, textY, delta);
            textY += line.getHeight() + 1;
        }
        RenderSystem.disableBlend();
        if (state.fireEvent()) {
            for (IInstanceRegistry.Entry entry : Registrar.get().eventListeners.get(Object.class)) {
                ((IEventListener)entry.instance()).onAfterTooltipRender(ctx, rect, ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            }
        }
        IWailaConfig.Overlay.Position.Align.Y iconPos = (IWailaConfig.Overlay.Position.Align.Y)((Object)PluginConfig.CLIENT.getEnum(WailaConstants.CONFIG_ICON_POSITION));
        int n = y + padding.top + Mth.m_14165_((double)((double)(height - (padding.top + padding.bottom) - icon.getHeight()) * iconPos.multiplier));
        if (iconPos == IWailaConfig.Overlay.Position.Align.Y.BOTTOM) {
            ++var14_21;
        }
        DisplayUtil.renderComponent(ctx, icon, x + padding.left, (int)var14_21, 0, delta);
        RenderSystem.enableDepthTest();
        ctx.m_280168_().m_85849_();
        profiler.m_7238_();
    }

    private static void narrateObjectName(Minecraft client) {
        ITooltipComponent iTooltipComponent;
        if (!state.render()) {
            return;
        }
        Narrator narrator = ((GameNarratorAccess)client.m_240477_()).wthit_narrator();
        if (!narrator.active() || !state.enableTextToSpeech() || Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
            return;
        }
        Line objectName = TOOLTIP.getLine(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && (iTooltipComponent = objectName.components.get(0)) instanceof WrappedComponent) {
            WrappedComponent component = (WrappedComponent)iTooltipComponent;
            String narrate = component.component.getString().replaceAll("\u00a7[a-z0-9]", "");
            if (!lastNarration.equalsIgnoreCase(narrate)) {
                CompletableFuture.runAsync(() -> narrator.say(narrate, true));
                lastNarration = narrate;
            }
        }
    }

    static {
        lastNarration = "";
        icon = EmptyComponent.INSTANCE;
        lastFrame = System.nanoTime();
        framebuffer = null;
    }

    public static interface State {
        public boolean render();

        public boolean fireEvent();

        public int getFps();

        public float getScale();

        public IWailaConfig.Overlay.Position.Align.X getXAnchor();

        public IWailaConfig.Overlay.Position.Align.Y getYAnchor();

        public IWailaConfig.Overlay.Position.Align.X getXAlign();

        public IWailaConfig.Overlay.Position.Align.Y getYAlign();

        public int getX();

        public int getY();

        public boolean bossBarsOverlap();

        public int getBackgroundAlpha();

        public ITheme getTheme();

        public boolean enableTextToSpeech();
    }

    private static enum Padding implements ITheme.Padding
    {
        INSTANCE;

        int top;
        int right;
        int bottom;
        int left;

        @Override
        public void set(int all) {
            this.set(all, all, all, all);
        }

        @Override
        public void set(int topBottom, int leftRight) {
            this.set(topBottom, leftRight, topBottom, leftRight);
        }

        @Override
        public void set(int top, int leftRight, int bottom) {
            this.set(top, leftRight, bottom, leftRight);
        }

        @Override
        public void set(int top, int right, int bottom, int left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }
    }
}

