/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopeslab.SlopeSlabShapes;

public final class FlatSlopeSlabCornerShapes
implements SplitShapeGenerator {
    public static final ShapeCache<SlopeSlabShape> SHAPES = FlatSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.SHAPES, BooleanOp.f_82689_);
    public static final ShapeCache<SlopeSlabShape> OCCLUSION_SHAPES = FlatSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.OCCLUSION_SHAPES, BooleanOp.f_82689_);
    public static final ShapeCache<SlopeSlabShape> INNER_SHAPES = FlatSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.SHAPES, BooleanOp.f_82695_);
    public static final ShapeCache<SlopeSlabShape> INNER_OCCLUSION_SHAPES = FlatSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.OCCLUSION_SHAPES, BooleanOp.f_82695_);
    public static final FlatSlopeSlabCornerShapes OUTER = new FlatSlopeSlabCornerShapes(SHAPES, OCCLUSION_SHAPES);
    public static final FlatSlopeSlabCornerShapes INNER = new FlatSlopeSlabCornerShapes(INNER_SHAPES, INNER_OCCLUSION_SHAPES);
    private final ShapeCache<SlopeSlabShape> shapes;
    private final ShapeCache<SlopeSlabShape> occlusionShapes;

    private FlatSlopeSlabCornerShapes(ShapeCache<SlopeSlabShape> shapes, ShapeCache<SlopeSlabShape> occlusionShapes) {
        this.shapes = shapes;
        this.occlusionShapes = occlusionShapes;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatSlopeSlabCornerShapes.generate(states, this.shapes);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatSlopeSlabCornerShapes.generate(states, this.occlusionShapes);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeSlabShape> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(cache.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF), Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(cache.get(SlopeSlabShape.BOTTOM_TOP_HALF), Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(cache.get(SlopeSlabShape.TOP_BOTTOM_HALF), Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(cache.get(SlopeSlabShape.TOP_TOP_HALF), Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.m_61143_((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.m_122416_() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<SlopeSlabShape> makeCache(ShapeCache<SlopeSlabShape> cache, BooleanOp joinOp) {
        return ShapeCache.createEnum(SlopeSlabShape.class, map -> {
            VoxelShape shapeSlopeBottom = cache.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
            VoxelShape shapeSlopeTop = cache.get(SlopeSlabShape.TOP_BOTTOM_HALF);
            VoxelShape shapeBottomBottomHalf = Shapes.m_83148_((VoxelShape)shapeSlopeBottom, (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeBottom), (BooleanOp)joinOp);
            map.put(SlopeSlabShape.BOTTOM_BOTTOM_HALF, shapeBottomBottomHalf);
            map.put(SlopeSlabShape.BOTTOM_TOP_HALF, shapeBottomBottomHalf.m_83216_(0.0, 0.5, 0.0));
            VoxelShape shapeTopBottomHalf = Shapes.m_83148_((VoxelShape)shapeSlopeTop, (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeSlopeTop), (BooleanOp)joinOp);
            map.put(SlopeSlabShape.TOP_BOTTOM_HALF, shapeTopBottomHalf);
            map.put(SlopeSlabShape.TOP_TOP_HALF, shapeTopBottomHalf.m_83216_(0.0, 0.5, 0.0));
        });
    }
}

