/*
 * Decompiled with CFR 0.152.
 */
package blueduck.dustrial.dustrialdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.m_61143_(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        return blockstate.m_60734_() == this ? (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(this.getDirectionForPlacement(context))));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        if (face.m_122434_() != Direction.Axis.Y) {
            return face;
        }
        Vec3 difference = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_())).m_82492_(0.5, 0.0, 0.5);
        return Direction.m_122364_((double)(-Math.toDegrees(Math.atan2(difference.m_7096_(), difference.m_7094_())))).m_122424_();
    }

    public boolean m_6864_(BlockState state, @Nonnull BlockPlaceContext context) {
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.m_61143_(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && context.m_43722_().m_41720_() == this.m_5456_() && context.m_7058_() && context.m_43719_() == slabtype.direction && this.getDirectionForPlacement(context) == slabtype.direction;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != VerticalSlabType.DOUBLE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return state;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && worldIn.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        @Nullable
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.direction = direction;
            String string2 = this.name = direction == null ? "double" : direction.m_7912_();
            if (direction == null) {
                this.shape = Shapes.m_83144_();
            } else {
                boolean isNegativeAxis = direction.m_122421_() == Direction.AxisDirection.NEGATIVE;
                double min = isNegativeAxis ? 8.0 : 0.0;
                double max = isNegativeAxis ? 16.0 : 8.0;
                this.shape = direction.m_122434_() == Direction.Axis.X ? Block.m_49796_((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.m_49796_((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

