/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.integrations.launchers;

import com.hypherionmc.simplerpc.RPCConstants;
import com.hypherionmc.simplerpc.enums.LauncherType;
import com.hypherionmc.simplerpc.integrations.launchers.Launcher;
import com.hypherionmc.simplerpc.integrations.launchers.types.ATLauncher;
import com.hypherionmc.simplerpc.integrations.launchers.types.CurseForge;
import com.hypherionmc.simplerpc.integrations.launchers.types.Modrinth;
import com.hypherionmc.simplerpc.integrations.launchers.types.MultiMC;
import com.hypherionmc.simplerpc.integrations.launchers.types.Technic;
import java.util.ArrayList;
import lombok.Generated;

public final class LauncherDetector {
    public static final LauncherDetector INSTANCE = new LauncherDetector();
    private LauncherType launcherType = LauncherType.UNKNOWN;
    private String launcherName = "Unknown Launcher";
    private String launcherPackName = "Unknown Pack";
    private String launcherIcon = "unknown";
    private final ArrayList<Launcher> supportedLaunchers = new ArrayList<Launcher>(){
        {
            new ATLauncher();
            new CurseForge();
            new Modrinth();
            new MultiMC();
            new Technic();
        }
    };

    public void loadLaunchers() {
        for (Launcher l : this.supportedLaunchers) {
            l.tryLoadLauncher();
            if (!l.hasLoaded()) continue;
            this.launcherType = l.getLauncherType();
            this.launcherName = l.getLauncherName();
            this.launcherIcon = l.getPackIcon();
            this.launcherPackName = l.getPackName();
            RPCConstants.logger.info("Found {} pack", (Object)l.getLauncherName());
            break;
        }
    }

    @Generated
    private LauncherDetector() {
    }

    @Generated
    public LauncherType getLauncherType() {
        return this.launcherType;
    }

    @Generated
    public String getLauncherName() {
        return this.launcherName;
    }

    @Generated
    public String getLauncherPackName() {
        return this.launcherPackName;
    }

    @Generated
    public String getLauncherIcon() {
        return this.launcherIcon;
    }

    @Generated
    public ArrayList<Launcher> getSupportedLaunchers() {
        return this.supportedLaunchers;
    }
}

