/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.rpcsdk.connection.unix;

import com.hypherionmc.simplerpc.rpcsdk.connection.unix.IUnixBackend;
import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NIOUnixBackend
implements IUnixBackend {
    private SocketChannel channel;

    @Override
    public void openPipe(String path) throws IOException {
        this.channel = SocketChannel.open(UnixDomainSocketAddress.of(path));
    }

    @Override
    public void closePipe() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.channel.close();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return;
        }
        this.channel.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public int getAvailable() throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.channel == null || !this.channel.isConnected()) {
            return -1;
        }
        return this.channel.read(ByteBuffer.wrap(bytes));
    }
}

