/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.json;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import moze_intel.projecte.api.imc.NSSCreatorInfo;
import moze_intel.projecte.api.nss.NSSCreator;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.InterModComms;

public class NSSSerializer
implements JsonSerializer<NormalizedSimpleStack>,
JsonDeserializer<NormalizedSimpleStack> {
    public static final NSSSerializer INSTANCE = new NSSSerializer();
    public static final NSSCreator fakeCreator = NSSFake::create;
    public static final NSSCreator itemCreator = itemName -> {
        if (itemName.startsWith("#")) {
            return NSSItem.createTag(NSSSerializer.getResourceLocation(itemName.substring(1), "item tag"));
        }
        int nbtStart = itemName.indexOf(123);
        ResourceLocation resourceLocation = NSSSerializer.getResourceLocation(nbtStart == -1 ? itemName : itemName.substring(0, nbtStart), "item");
        if (nbtStart == -1) {
            return NSSItem.createItem(resourceLocation);
        }
        String nbtAsString = itemName.substring(nbtStart);
        try {
            return NSSItem.createItem(resourceLocation, TagParser.m_129359_((String)nbtAsString));
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Malformed NBT compound", (Throwable)e);
        }
    };
    public static final NSSCreator fluidCreator = fluidName -> {
        if (fluidName.startsWith("#")) {
            return NSSFluid.createTag(NSSSerializer.getResourceLocation(fluidName.substring(1), "fluid tag"));
        }
        int nbtStart = fluidName.indexOf(123);
        ResourceLocation resourceLocation = NSSSerializer.getResourceLocation(nbtStart == -1 ? fluidName : fluidName.substring(0, nbtStart), "fluid");
        if (nbtStart == -1) {
            return NSSFluid.createFluid(resourceLocation);
        }
        String nbtAsString = fluidName.substring(nbtStart);
        try {
            return NSSFluid.createFluid(resourceLocation, TagParser.m_129359_((String)nbtAsString));
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Malformed NBT compound", (Throwable)e);
        }
    };
    private Map<String, NSSCreator> creators = Collections.emptyMap();

    private static ResourceLocation getResourceLocation(String s, String type) throws JsonParseException {
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException e) {
            throw new JsonParseException("Malformed " + type + " ID", (Throwable)e);
        }
    }

    public void setCreators(Map<String, NSSCreator> creators) {
        this.creators = ImmutableMap.copyOf(creators);
    }

    public NormalizedSimpleStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize(json.getAsString());
    }

    public NormalizedSimpleStack deserialize(String s) {
        String[] parts;
        String key;
        if (s.contains("|") && this.creators.containsKey(key = (parts = s.split("\\|"))[0])) {
            return this.creators.get(key).create(parts[1]);
        }
        return itemCreator.create(s);
    }

    public JsonElement serialize(NormalizedSimpleStack src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.json());
    }

    public static void init() {
        NSSSerializer.registerDefault("FAKE", fakeCreator);
        NSSSerializer.registerDefault("ITEM", itemCreator);
        NSSSerializer.registerDefault("FLUID", fluidCreator);
    }

    private static void registerDefault(String key, NSSCreator creator) {
        InterModComms.sendTo((String)"projecte", (String)"register_nss_serializer", () -> new NSSCreatorInfo(key, creator));
    }
}

