/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registration;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import moze_intel.projecte.gameObjs.registration.DoubleWrappedRegistryObject;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DoubleDeferredRegister<PRIMARY, SECONDARY> {
    @NotNull
    protected final DeferredRegister<PRIMARY> primaryRegister;
    @NotNull
    protected final DeferredRegister<SECONDARY> secondaryRegister;

    public DoubleDeferredRegister(IForgeRegistry<PRIMARY> primaryRegistry, IForgeRegistry<SECONDARY> secondaryRegistry, String modid) {
        this.primaryRegister = DeferredRegister.create(primaryRegistry, (String)modid);
        this.secondaryRegister = DeferredRegister.create(secondaryRegistry, (String)modid);
    }

    public <P extends PRIMARY, S extends SECONDARY, W extends DoubleWrappedRegistryObject<P, S>> W register(String name, Supplier<? extends P> primarySupplier, Supplier<? extends S> secondarySupplier, BiFunction<RegistryObject<P>, RegistryObject<S>, W> objectWrapper) {
        return (W)((DoubleWrappedRegistryObject)objectWrapper.apply(this.primaryRegister.register(name, primarySupplier), this.secondaryRegister.register(name, secondarySupplier)));
    }

    public <P extends PRIMARY, S extends SECONDARY, W extends DoubleWrappedRegistryObject<P, S>> W register(String name, Supplier<? extends P> primarySupplier, Function<P, S> secondarySupplier, BiFunction<RegistryObject<P>, RegistryObject<S>, W> objectWrapper) {
        RegistryObject primaryObject = this.primaryRegister.register(name, primarySupplier);
        return (W)((DoubleWrappedRegistryObject)objectWrapper.apply(primaryObject, this.secondaryRegister.register(name, () -> secondarySupplier.apply(primaryObject.get()))));
    }

    public void register(IEventBus bus) {
        this.primaryRegister.register(bus);
        this.secondaryRegister.register(bus);
    }
}

