/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.uv.IconTransformation;
import mrtjp.projectred.transmission.client.WireModelBuilder;
import mrtjp.projectred.transmission.part.BaseFaceWirePart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class WireModelRenderer {
    private static final CCModel[] wireModels = new CCModel[4608];
    private static final CCModel[] inventoryWireModels = new CCModel[3];

    public static int modelKey(int side, int thickness, int connMap) {
        int key = connMap & 0xFF;
        int renderCorner = connMap >> 20 & 0xF;
        key |= (renderCorner ^ key & 0xF) << 4;
        key &= 0xFFFFFFF0 | renderCorner;
        int internal = (connMap & 0xF00) >> 8;
        key |= internal << 4 | internal;
        return key |= side + thickness * 6 << 8;
    }

    private static int modelKey(BaseFaceWirePart wire) {
        return WireModelRenderer.modelKey(wire.getSide(), wire.getWireType().getThickness(), wire.getConnMap());
    }

    private static CCModel getOrGenerateModel(int key) {
        CCModel model = wireModels[key];
        if (model == null) {
            WireModelRenderer.wireModels[key] = model = new WireModelBuilder().setModelKey(key).build();
        }
        return model;
    }

    private static CCModel getOrGenerateInventoryModel(int thickness) {
        CCModel model = inventoryWireModels[thickness];
        if (model == null) {
            int key = WireModelRenderer.modelKey(0, thickness, 240);
            WireModelRenderer.inventoryWireModels[thickness] = model = new WireModelBuilder().setModelKey(key).setInventory(true).build();
        }
        return model;
    }

    public static void render(CCRenderState ccrs, BaseFaceWirePart wire) {
        WireModelRenderer.getOrGenerateModel(WireModelRenderer.modelKey(wire)).render(ccrs, new IVertexOperation[]{new IconTransformation(wire.getIcon()), ColourMultiplier.instance((int)wire.getRenderHue())});
    }

    public static void render(CCRenderState ccrs, int modelKey, int hue, TextureAtlasSprite icon, Transformation transformation) {
        WireModelRenderer.getOrGenerateModel(modelKey).render(ccrs, new IVertexOperation[]{new IconTransformation(icon), ColourMultiplier.instance((int)hue), transformation});
    }

    public static void renderInventory(CCRenderState ccrs, int thickness, int hue, TextureAtlasSprite icon, Transformation transformation) {
        WireModelRenderer.getOrGenerateInventoryModel(thickness).render(ccrs, new IVertexOperation[]{new IconTransformation(icon), ColourMultiplier.instance((int)hue), transformation});
    }
}

