/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.fabrication.gui.ICompileOverlayRenderer;
import mrtjp.projectred.fabrication.gui.ProblemListNode;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.ScrollBarNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;

public class CompileProblemsTab
extends AbstractGuiNode
implements ICompileOverlayRenderer {
    private final ICWorkbenchEditor editor;
    private final ProblemListNode issueListNode = new ProblemListNode();

    public CompileProblemsTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.setSize(91, 134);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.issueListNode.setPosition(6, 31);
        this.issueListNode.setSize(79, 95);
        this.addChild((RedUINode)this.issueListNode);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setPosition(77, 31);
        scrollBar.setZPosition(0.2);
        scrollBar.setSize(8, 95);
        scrollBar.setSliderSize(8, 16);
        this.addChild((RedUINode)scrollBar);
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.m_280163_(ICWorkbenchCompileTab.TAB_BACKGROUND, this.getFrame().x(), this.getFrame().y(), 184.0f, 223.0f, this.getFrame().width(), this.getFrame().height(), 512, 512);
    }

    public void onAddedToParent() {
        this.editor.getStateMachine().getCompilerLog().addTreeChangedListener(this::refreshList);
        this.refreshList();
    }

    private void refreshList() {
        this.issueListNode.setProblemList(this.editor.getStateMachine().getCompilerLog().getProblems());
    }

    @Override
    public void renderOverlay(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ccrs.reset();
        ccrs.bind(ICRenderTypes.selectionRenderType, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), matrixStack);
        for (CompileProblem problem : this.editor.getStateMachine().getCompilerLog().getProblems()) {
            problem.renderOverlay(mousePosition, ccrs, getter, matrixStack);
        }
    }

    @Override
    public void buildTooltip(ICRenderNode renderNode, Vector3 mousePosition, List<Component> tooltip) {
        TileCoord pos = IICEditorTool.toNearestPosition(mousePosition);
        for (CompileProblem issue : this.editor.getStateMachine().getCompilerLog().getProblems()) {
            issue.buildToolTip(tooltip, pos);
        }
    }

    private class ScrollBar
    extends ScrollBarNode {
        public ScrollBar() {
            super(ScrollBarNode.ScrollAxis.VERTICAL);
        }

        protected void drawSlider(GuiGraphics graphics, Rect sliderFrame) {
            graphics.m_280163_(ICWorkbenchCompileTab.TAB_BACKGROUND, sliderFrame.x(), sliderFrame.y(), 305.0f, 58.0f, sliderFrame.width(), sliderFrame.height(), 512, 512);
        }

        protected void adjustContent(double scrollPercentage) {
            CompileProblemsTab.this.issueListNode.setScrollPercentage(scrollPercentage);
        }
    }
}

