/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import java.util.ArrayList;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchInfoTab;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.init.FabricationParts;
import mrtjp.projectred.fabrication.lithography.LithographyPipeline;
import mrtjp.projectred.fabrication.lithography.YieldCalculator;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.ItemStackNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PipelineDiagramNode
extends AbstractGuiNode {
    private final YieldCalculator yieldCalculator;
    private BasicPipelineItems basicPipelineItems;
    private AbstractGuiNode advancedPipelineItems;

    public PipelineDiagramNode(YieldCalculator yieldCalculator) {
        this.yieldCalculator = yieldCalculator;
        this.setSize(280, 56);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.basicPipelineItems = new BasicPipelineItems();
        this.addChild((RedUINode)this.basicPipelineItems);
        this.advancedPipelineItems = new AbstractGuiNode(){};
        this.addChild((RedUINode)this.advancedPipelineItems);
        this.updatePipelines();
    }

    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
    }

    public void update() {
        this.updatePipelines();
    }

    private void updatePipelines() {
        boolean isBasic = this.yieldCalculator.getPipeline() == LithographyPipeline.BASIC;
        this.basicPipelineItems.setHidden(!isBasic);
        this.advancedPipelineItems.setHidden(isBasic);
    }

    private class BasicPipelineItems
    extends AbstractGuiNode {
        private final ArrayList<ItemStackNode> items = new ArrayList();

        public BasicPipelineItems() {
            this.addItem(new ItemStack((ItemLike)FabricationItems.IC_BLUEPRINT_ITEM.get()), 30, 5);
            this.addItem(new ItemStack((ItemLike)FabricationBlocks.PLOTTING_TABLE_BLOCK.get()), 64, 5);
            this.addItem(new ItemStack((ItemLike)FabricationItems.BLANK_PHOTOMASK_ITEM.get()), 64, 39);
            this.addItem(new ItemStack((ItemLike)FabricationItems.PHOTOMASK_SET_ITEM.get()), 98, 5);
            this.addItem(new ItemStack((ItemLike)FabricationBlocks.LITHOGRAPHY_TABLE_BLOCK.get()), 132, 5);
            this.addItem(new ItemStack((ItemLike)FabricationItems.ROUGH_SILICON_WAFER_ITEM.get()), 132, 39);
            this.addItem(new ItemStack((ItemLike)FabricationItems.VALID_DIE_ITEM.get()), 166, 5);
            this.addItem(new ItemStack((ItemLike)FabricationBlocks.PACKAGING_TABLE_BLOCK.get()), 200, 5);
            this.addItem(new ItemStack((ItemLike)FabricationParts.FABRICATED_GATE_ITEM.get()), 234, 5);
        }

        private void addItem(ItemStack stack, int x, int y) {
            ItemStackNode stackNode = new ItemStackNode(stack);
            stackNode.setPosition(x, y);
            this.items.add(stackNode);
            this.addChild((RedUINode)stackNode);
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            graphics.m_280163_(ICWorkbenchInfoTab.TAB_BACKGROUND, this.getFrame().x(), this.getFrame().y(), 1.0f, 223.0f, 280, 56, 512, 512);
        }

        public void update() {
            ItemStackNode node = this.items.get(5);
            switch (PipelineDiagramNode.this.yieldCalculator.getWaferType()) {
                case ROUGH_WAFER: {
                    node.setItemStack(new ItemStack((ItemLike)FabricationItems.ROUGH_SILICON_WAFER_ITEM.get()));
                    break;
                }
                case POLISHED_WAFER: 
                case PURIFIED_WAFER: {
                    node.setItemStack(ItemStack.f_41583_);
                }
            }
        }
    }
}

