/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.equipment.bauble.CirrusAmuletItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

public class SojournersSashItem
extends BaubleItem {
    private static final UUID STEP_BOOST_UUID = UUID.fromString("8511cd62-2650-4078-8d69-9ebe80b21eb5");
    private static final AttributeModifier STEP_BOOST = new AttributeModifier(STEP_BOOST_UUID, "botania:travel_belt", 0.65, AttributeModifier.Operation.ADDITION);
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/belt_travel.png");
    private static final int COST = 1;
    private static final int COST_INTERVAL = 10;
    public final float speed;
    public final float jump;
    public final float fallBuffer;

    public SojournersSashItem(Item.Properties props) {
        this(props, 0.035f, 0.2f, 2.0f);
    }

    public static float onPlayerFall(Player entity, float dist) {
        boolean pendantJump = CirrusAmuletItem.popJumping(entity);
        ItemStack stack = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof SojournersSashItem, (LivingEntity)entity);
        if (!stack.m_41619_()) {
            ItemStack amulet;
            float fallBuffer = ((SojournersSashItem)stack.m_41720_()).fallBuffer;
            if (pendantJump && !(amulet = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof CirrusAmuletItem, (LivingEntity)entity)).m_41619_()) {
                fallBuffer *= (float)((CirrusAmuletItem)amulet.m_41720_()).getMaxAllowedJumps();
            }
            return Math.max(0.0f, dist - fallBuffer);
        }
        return dist;
    }

    public SojournersSashItem(Item.Properties props, float speed, float jump, float fallBuffer) {
        super(props);
        this.speed = speed;
        this.jump = jump;
        this.fallBuffer = fallBuffer;
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public static void tickBelt(Player player) {
        ItemStack belt = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof SojournersSashItem, (LivingEntity)player);
        Attribute stepHeight = XplatAbstractions.INSTANCE.getStepHeightAttribute();
        AttributeInstance attrib = player.m_21051_(stepHeight);
        boolean hasBoost = attrib.m_22109_(STEP_BOOST);
        if (SojournersSashItem.tryConsumeMana(player)) {
            if (player.m_9236_().f_46443_) {
                SojournersSashItem beltItem = (SojournersSashItem)belt.m_41720_();
                if ((player.m_20096_() || player.m_150110_().f_35935_) && player.f_20902_ > 0.0f && !player.m_20072_()) {
                    float speed = beltItem.getSpeed(belt);
                    player.m_19920_(player.m_150110_().f_35935_ ? speed : speed, new Vec3(0.0, 0.0, 1.0));
                    beltItem.onMovedTick(belt, player);
                    if (player.f_19797_ % 10 == 0) {
                        ManaItemHandler.instance().requestManaExact(belt, player, 1, true);
                    }
                } else {
                    beltItem.onNotMovingTick(belt, player);
                }
            } else if (player.m_6144_()) {
                if (hasBoost) {
                    attrib.m_22130_(STEP_BOOST);
                }
            } else if (!hasBoost) {
                attrib.m_22118_(STEP_BOOST);
            }
        } else if (!player.m_9236_().f_46443_ && hasBoost) {
            attrib.m_22130_(STEP_BOOST);
        }
    }

    public float getSpeed(ItemStack stack) {
        return this.speed;
    }

    public void onMovedTick(ItemStack stack, Player player) {
    }

    public void onNotMovingTick(ItemStack stack, Player player) {
    }

    public static void onPlayerJump(LivingEntity living) {
        Player player;
        ItemStack belt;
        if (living instanceof Player && !(belt = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof SojournersSashItem, (LivingEntity)(player = (Player)living))).m_41619_() && ManaItemHandler.instance().requestManaExact(belt, player, 1, false)) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)((SojournersSashItem)belt.m_41720_()).jump, 0.0));
        }
    }

    private static boolean tryConsumeMana(Player player) {
        ItemStack result = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof SojournersSashItem, (LivingEntity)player);
        return !result.m_41619_() && ManaItemHandler.instance().requestManaExact(result, player, 1, false);
    }

    ResourceLocation getRenderTexture() {
        return texture;
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static HumanoidModel<LivingEntity> model = null;

        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryRenderHelper.rotateIfSneaking(ms, living);
            float s = 1.15f;
            ms.m_85841_(s, s, s);
            if (model == null) {
                model = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_));
            }
            ResourceLocation texture = ((SojournersSashItem)stack.m_41720_()).getRenderTexture();
            VertexConsumer buffer = buffers.m_6299_(model.m_103119_(texture));
            Renderer.model.f_102810_.m_104306_(ms, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

