/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.mapicon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftbchunks.client.mapicon.StaticMapIcon;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ImageIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityMapIcon
implements MapIcon {
    private final Entity entity;
    private final Icon icon;

    public EntityMapIcon(Entity entity, Icon icon) {
        this.entity = entity;
        this.icon = icon;
    }

    @Override
    public Vec3 getPos(float partialTick) {
        return partialTick >= 1.0f ? this.entity.m_20182_() : this.entity.m_20318_(partialTick);
    }

    @Override
    public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        return !mapType.isWorldIcon() && (this.entity instanceof AbstractClientPlayer || !outsideVisibleArea);
    }

    @Override
    public double getIconScale(MapType mapType) {
        return this.entity instanceof AbstractClientPlayer || !mapType.isMinimap() || (Boolean)FTBChunksClientConfig.MINIMAP_LARGE_ENTITIES.get() != false ? 1.0 : 0.6666666666666666;
    }

    @Override
    public boolean isZoomDependant(MapType mapType) {
        return !(this.entity instanceof AbstractClientPlayer);
    }

    @Override
    public int getPriority() {
        return this.entity instanceof LocalPlayer ? 150 : (this.entity instanceof AbstractClientPlayer ? 100 : 0);
    }

    @Override
    public void addTooltip(TooltipList list) {
        list.add(this.entity.m_7755_());
    }

    @Override
    public boolean onMousePressed(BaseScreen screen, MouseButton button) {
        return false;
    }

    @Override
    public boolean onKeyPressed(BaseScreen screen, Key key) {
        return !(this.entity instanceof LocalPlayer) && StaticMapIcon.handleKeypress(this, screen, key);
    }

    @Override
    public void draw(MapType mapType, GuiGraphics graphics, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
        if (this.icon instanceof ImageIcon) {
            TextureManager manager = Minecraft.m_91087_().m_91097_();
            AbstractTexture tex = manager.m_118506_(((ImageIcon)this.icon).texture);
            if (tex == null) {
                tex = new SimpleTexture(((ImageIcon)this.icon).texture);
                manager.m_118495_(((ImageIcon)this.icon).texture, tex);
            }
            RenderSystem.bindTextureForSetup((int)tex.m_117963_());
            RenderSystem.texParameter((int)3553, (int)10241, (int)(w > 4 ? 9728 : 9729));
            RenderSystem.texParameter((int)3553, (int)10240, (int)(w > 4 ? 9728 : 9729));
        }
        if (!(this.entity instanceof AbstractClientPlayer) || mapType.isMinimap() || w < 4 || this.icon == EntityIcons.NORMAL || this.icon == EntityIcons.HOSTILE) {
            this.icon.draw(graphics, x, y, w, h);
        } else {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_((float)w / 18.0f, (float)h / 18.0f, 1.0f);
            Color4I.BLACK.draw(graphics, 0, 0, 18, 18);
            this.icon.draw(graphics, 1, 1, 16, 16);
            poseStack.m_85849_();
        }
    }
}

