/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item.base;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.tarantel.chickenroost.item.base.RoostUltimateItem;

public class ChickenBlockItem
extends RoostUltimateItem {
    @Deprecated
    private final Block block;

    public ChickenBlockItem(Block block, Item.Properties properties, int currentmaxxp) {
        super(properties);
        this.block = block;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!this.getBlock().m_245993_(context.m_43725_().m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.updatePlacementContext(context);
        if (blockplacecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockplacecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockplacecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockplacecontext.m_8083_();
        Level level = blockplacecontext.m_43725_();
        Player player = blockplacecontext.m_43723_();
        ItemStack itemstack = blockplacecontext.m_43722_();
        BlockState blockstate1 = level.m_8055_(blockpos);
        if (blockstate1.m_60713_(blockstate.m_60734_())) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, level, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            ChickenBlockItem.updateBlockEntityComponents(level, blockpos, itemstack);
            blockstate1.m_60734_().m_6402_(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.m_43723_());
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate1));
        itemstack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState state) {
        return state.m_60827_().m_56777_();
    }

    protected SoundEvent getPlaceSound(BlockState p_state, Level world, BlockPos pos, Player entity) {
        return p_state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    private static void updateBlockEntityComponents(Level level, BlockPos poa, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(poa);
        if (blockentity != null) {
            blockentity.m_187476_(stack);
            blockentity.m_6596_();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return ChickenBlockItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockstate = this.getBlock().m_5573_(context);
        return blockstate != null && this.canPlace(context, blockstate) ? blockstate : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        if (!stack.m_41782_()) {
            return state;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_("BlockStateTag")) {
            return state;
        }
        CompoundTag blockStateTag = nbt.m_128469_("BlockStateTag");
        BlockState blockstate = this.getBlock().m_49966_();
        if (blockstate != state) {
            level.m_7731_(pos, blockstate, 2);
        }
        return blockstate;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.m_43723_();
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return (!this.mustSurvive() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), collisioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockentity;
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag customdata = stack.m_41737_("BlockEntityTag");
        if (customdata != null && !customdata.m_128456_() && (blockentity = level.m_7702_(pos)) != null) {
            if (!(level.f_46443_ || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                return false;
            }
            blockentity.m_142466_(customdata);
            return true;
        }
        return false;
    }

    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        this.getBlock().m_5871_(itemstack, (BlockGetter)world, list, flag);
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> blockToItemMap, Item item) {
        blockToItemMap.put(this.getBlock(), item);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
    }

    public boolean m_142095_() {
        return !(this.getBlock() instanceof ShulkerBoxBlock);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        CompoundTag containerTag = stack.m_41737_("Items");
        if (containerTag != null && !containerTag.m_128456_()) {
            NonNullList items = NonNullList.m_122780_((int)containerTag.m_128451_("Size"), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)containerTag, (NonNullList)items);
            ItemUtils.m_150952_((ItemEntity)itemEntity, (Stream)((Stream)items));
        }
    }

    public static void setBlockEntityData(ItemStack stack, BlockEntityType<?> blockEntityType, CompoundTag blockEntityData) {
        blockEntityData.m_128473_("id");
        if (blockEntityData.m_128456_()) {
            stack.m_41749_("BlockEntityTag");
        } else {
            blockEntityData.m_128359_("id", ForgeRegistries.BLOCK_ENTITY_TYPES.getKey(blockEntityType).toString());
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)blockEntityData);
        }
    }

    public FeatureFlagSet m_245183_() {
        return this.getBlock().m_245183_();
    }
}

