/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.item;

import codechicken.lib.util.ServerUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.exploration.init.ExplorationTags;
import mrtjp.projectred.exploration.inventory.container.BackpackMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BackpackItem
extends Item {
    public static final String TAG_INVENTORY = "backpack_inventory";
    public static final String TAG_IS_OPENED = "is_opened";
    private final int colour;

    public BackpackItem(int colour) {
        super(new Item.Properties().m_41487_(1));
        this.colour = colour;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ServerPlayer player;
        if (!context.m_43725_().f_46443_ && (player = (ServerPlayer)context.m_43723_()) != null) {
            this.openGui(player);
        }
        return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openGui(serverPlayer);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private void openGui(ServerPlayer player) {
        ServerUtils.openContainer((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new BackpackMenu(windowId, playerInventory), (Component)Component.m_237115_((String)this.m_5524_())));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (BackpackItem.isBackpackOpened(stack)) {
            return;
        }
        int itemCount = BackpackItem.getBackpackItemCount(stack);
        tooltip.add((Component)Component.m_237113_((String)(itemCount + " / 27")).m_130940_(ChatFormatting.GRAY));
    }

    public DyeColor getDyeColor() {
        return DyeColor.m_41053_((int)this.colour);
    }

    public static boolean isBackpack(ItemStack stack) {
        return stack.m_41720_() instanceof BackpackItem;
    }

    public static boolean hasBackpackInventory(ItemStack stack) {
        return BackpackItem.isBackpack(stack) && stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_(TAG_INVENTORY);
    }

    public static CompoundTag getBackpackInventoryTag(ItemStack stack) {
        if (BackpackItem.hasBackpackInventory(stack)) {
            return Objects.requireNonNull(stack.m_41783_()).m_128469_(TAG_INVENTORY);
        }
        return new CompoundTag();
    }

    public static int getBackpackItemCount(ItemStack stack) {
        if (BackpackItem.hasBackpackInventory(stack)) {
            return BaseContainer.getItemCount((CompoundTag)Objects.requireNonNull(stack.m_41783_()).m_128469_(TAG_INVENTORY));
        }
        return 0;
    }

    public static void saveBackpackInventory(ItemStack stack, CompoundTag inventoryTag) {
        stack.m_41784_().m_128365_(TAG_INVENTORY, (Tag)inventoryTag);
    }

    public static void deleteBackpackInventory(ItemStack stack) {
        if (BackpackItem.hasBackpackInventory(stack)) {
            Objects.requireNonNull(stack.m_41783_()).m_128473_(TAG_INVENTORY);
        }
    }

    public static void setBackpackOpenedFlag(ItemStack stack, boolean opened) {
        if (BackpackItem.isBackpack(stack)) {
            CompoundTag tag = stack.m_41784_();
            if (opened) {
                tag.m_128379_(TAG_IS_OPENED, true);
            } else {
                tag.m_128473_(TAG_IS_OPENED);
            }
        }
    }

    public static boolean isBackpackOpened(ItemStack stack) {
        return BackpackItem.isBackpack(stack) && stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128471_(TAG_IS_OPENED);
    }

    public static boolean isItemAllowedInBackpack(ItemStack stack) {
        return !stack.m_204117_(ExplorationTags.BACKPACKS_DISALLOWED_TAG);
    }
}

