/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class NewInputSlotCrafter<T extends AbstractContainerMenu, C extends Container>
extends InputSlotCrafter<T, C> {
    protected final List<SlotAccessor> inputSlots;
    protected final List<SlotAccessor> inventorySlots;
    protected final List<InputIngredient<ItemStack>> inputs;

    public NewInputSlotCrafter(T container, List<SlotAccessor> inputSlots, List<SlotAccessor> inventorySlots, List<InputIngredient<ItemStack>> inputs) {
        super(container);
        this.inputSlots = inputSlots;
        this.inventorySlots = inventorySlots;
        this.inputs = inputs;
    }

    @Override
    protected Iterable<SlotAccessor> getInputSlots() {
        return this.inputSlots;
    }

    @Override
    protected Iterable<SlotAccessor> getInventorySlots() {
        return this.inventorySlots;
    }

    @Override
    protected List<InputIngredient<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    protected void populateRecipeFinder(RecipeFinder recipeFinder) {
        for (SlotAccessor slot : this.getInventorySlots()) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
    }

    @Override
    protected void markDirty() {
        this.player.m_150109_().m_6596_();
        this.container.m_150429_();
    }

    @Override
    protected void cleanInputs() {
        for (SlotAccessor slot : this.getInputSlots()) {
            ItemStack stackToReturn = slot.getItemStack();
            if (!slot.allowModification((Player)this.player)) {
                throw new IllegalStateException("Slot " + slot + " is not modifiable!");
            }
            if (stackToReturn.m_41619_()) continue;
            while (!(stackToReturn = slot.getItemStack()).m_41619_()) {
                ItemStack stackToInsert = stackToReturn.m_41777_();
                stackToInsert.m_41764_(1);
                if (!this.getDumpHandler().test(stackToInsert)) {
                    throw new IllegalStateException("rei.rei.no.slot.in.inv");
                }
                slot.takeStack(1);
            }
        }
    }

    private Predicate<ItemStack> getDumpHandler() {
        return stackToDump -> {
            SlotAccessor nextSlot;
            Iterable<SlotAccessor> inventoryStacks = this.getInventorySlots();
            SlotAccessor occupiedSlotWithRoomForStack = NewInputSlotCrafter.getOccupiedSlotWithRoomForStack(stackToDump, inventoryStacks);
            SlotAccessor emptySlot = NewInputSlotCrafter.getEmptySlot(inventoryStacks);
            SlotAccessor slotAccessor = nextSlot = occupiedSlotWithRoomForStack == null ? emptySlot : occupiedSlotWithRoomForStack;
            if (nextSlot == null) {
                return false;
            }
            ItemStack stack = stackToDump.m_41777_();
            stack.m_41764_(nextSlot.getItemStack().m_41613_() + stack.m_41613_());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    static SlotAccessor getOccupiedSlotWithRoomForStack(ItemStack stack, Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!NewInputSlotCrafter.canStackAddMore(inventoryStack.getItemStack(), stack)) continue;
            return inventoryStack;
        }
        return null;
    }

    static SlotAccessor getEmptySlot(Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!inventoryStack.getItemStack().m_41619_()) continue;
            return inventoryStack;
        }
        return null;
    }

    static boolean canStackAddMore(ItemStack existingStack, ItemStack stack) {
        return !existingStack.m_41619_() && ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack) && existingStack.m_41753_() && existingStack.m_41613_() + stack.m_41613_() <= existingStack.m_41741_();
    }
}

