/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.effect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mekanism.common.lib.Color;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BoltEffect {
    private final Random random = new Random();
    private final BoltRenderInfo renderInfo;
    private final Vec3 start;
    private final Vec3 end;
    private final int segments;
    private int count = 1;
    private float size = 0.1f;
    private int lifespan = 30;
    private SpawnFunction spawnFunction = SpawnFunction.delay(60.0f);
    private FadeFunction fadeFunction = FadeFunction.fade(0.5f);

    public BoltEffect(Vec3 start, Vec3 end) {
        this(BoltRenderInfo.DEFAULT, start, end, (int)Math.sqrt(start.m_82554_(end) * 100.0));
    }

    public BoltEffect(BoltRenderInfo info, Vec3 start, Vec3 end, int segments) {
        this.renderInfo = info;
        this.start = start;
        this.end = end;
        this.segments = segments;
    }

    public BoltEffect count(int count) {
        this.count = count;
        return this;
    }

    public BoltEffect size(float size) {
        this.size = size;
        return this;
    }

    public BoltEffect spawn(SpawnFunction spawnFunction) {
        this.spawnFunction = spawnFunction;
        return this;
    }

    public BoltEffect fade(FadeFunction fadeFunction) {
        this.fadeFunction = fadeFunction;
        return this;
    }

    public BoltEffect lifespan(int lifespan) {
        this.lifespan = lifespan;
        return this;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public SpawnFunction getSpawnFunction() {
        return this.spawnFunction;
    }

    public FadeFunction getFadeFunction() {
        return this.fadeFunction;
    }

    public Color getColor() {
        return this.renderInfo.color;
    }

    public List<BoltQuads> generate() {
        ArrayList<BoltQuads> quads = new ArrayList<BoltQuads>();
        Vec3 diff = this.end.m_82546_(this.start);
        float totalDistance = (float)diff.m_82553_();
        block0: for (int i = 0; i < this.count; ++i) {
            LinkedList<BoltInstructions> drawQueue = new LinkedList<BoltInstructions>();
            drawQueue.add(new BoltInstructions(this.start, 0.0f, new Vec3(0.0, 0.0, 0.0), null, false));
            while (!drawQueue.isEmpty()) {
                Vec3 segmentEnd;
                BoltInstructions data = (BoltInstructions)drawQueue.poll();
                Vec3 perpendicularDist = data.perpendicularDist;
                float progress = data.progress + 1.0f / (float)this.segments * (1.0f - this.renderInfo.parallelNoise + this.random.nextFloat() * this.renderInfo.parallelNoise * 2.0f);
                float segmentDiffScale = this.renderInfo.spreadFunction.getMaxSpread(progress);
                if (progress >= 1.0f && segmentDiffScale <= 0.0f) {
                    segmentEnd = this.end;
                } else {
                    float maxDiff = this.renderInfo.spreadFactor * segmentDiffScale * totalDistance;
                    Vec3 randVec = BoltEffect.findRandomOrthogonalVector(diff, this.random);
                    double rand = this.renderInfo.randomFunction.getRandom(this.random);
                    perpendicularDist = this.renderInfo.segmentSpreader.getSegmentAdd(perpendicularDist, randVec, maxDiff, segmentDiffScale, progress, rand);
                    segmentEnd = this.start.m_82549_(diff.m_82490_((double)progress)).m_82549_(perpendicularDist);
                }
                float boltSize = this.size * (0.5f + (1.0f - progress) * 0.5f);
                BoltQuadData quadData = this.createQuads(data.cache, data.start, segmentEnd, boltSize);
                quads.add(quadData.quads());
                if (progress >= 1.0f) continue block0;
                if (!data.isBranch) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), false));
                } else if (this.random.nextFloat() < this.renderInfo.branchContinuationFactor) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), true));
                }
                while (this.random.nextFloat() < this.renderInfo.branchInitiationFactor * (1.0f - progress)) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, quadData.cache(), true));
                }
            }
        }
        return quads;
    }

    private static Vec3 findRandomOrthogonalVector(Vec3 vec, Random rand) {
        Vec3 newVec = new Vec3(-0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
        return vec.m_82537_(newVec).m_82541_();
    }

    private BoltQuadData createQuads(QuadCache cache, Vec3 startPos, Vec3 end, float size) {
        Vec3 diff = end.m_82546_(startPos);
        Vec3 rightAdd = diff.m_82537_(new Vec3(0.5, 0.5, 0.5)).m_82541_().m_82490_((double)size);
        Vec3 backAdd = diff.m_82537_(rightAdd).m_82541_().m_82490_((double)size);
        Vec3 rightAddSplit = rightAdd.m_82490_(0.5);
        Vec3 start = cache == null ? startPos : cache.prevEnd;
        Vec3 startRight = cache == null ? start.m_82549_(rightAdd) : cache.prevEndRight;
        Vec3 startBack = cache == null ? start.m_82549_(rightAddSplit).m_82549_(backAdd) : cache.prevEndBack;
        Vec3 endRight = end.m_82549_(rightAdd);
        Vec3 endBack = end.m_82549_(rightAddSplit).m_82549_(backAdd);
        BoltQuads quads = new BoltQuads();
        quads.addQuad(start, end, endRight, startRight);
        quads.addQuad(startRight, endRight, end, start);
        quads.addQuad(startRight, endRight, endBack, startBack);
        quads.addQuad(startBack, endBack, endRight, startRight);
        return new BoltQuadData(quads, new QuadCache(end, endRight, endBack));
    }

    public static class BoltRenderInfo {
        public static final BoltRenderInfo DEFAULT = new BoltRenderInfo();
        public static final BoltRenderInfo ELECTRICITY = BoltRenderInfo.electricity();
        private float parallelNoise = 0.1f;
        private float spreadFactor = 0.1f;
        private float branchInitiationFactor = 0.0f;
        private float branchContinuationFactor = 0.0f;
        private Color color = Color.rgbad(0.45f, 0.45f, 0.5, 0.8f);
        private RandomFunction randomFunction = RandomFunction.GAUSSIAN;
        private SpreadFunction spreadFunction = SpreadFunction.SINE;
        private SegmentSpreader segmentSpreader = SegmentSpreader.NO_MEMORY;

        public static BoltRenderInfo electricity() {
            return new BoltRenderInfo().color(Color.rgbad(0.54f, 0.91f, 1.0, 0.8f)).noise(0.2f, 0.2f).branching(0.1f, 0.6f).spreader(SegmentSpreader.memory(0.9f));
        }

        public BoltRenderInfo noise(float parallelNoise, float spreadFactor) {
            this.parallelNoise = parallelNoise;
            this.spreadFactor = spreadFactor;
            return this;
        }

        public BoltRenderInfo branching(float branchInitiationFactor, float branchContinuationFactor) {
            this.branchInitiationFactor = branchInitiationFactor;
            this.branchContinuationFactor = branchContinuationFactor;
            return this;
        }

        public BoltRenderInfo spreader(SegmentSpreader segmentSpreader) {
            this.segmentSpreader = segmentSpreader;
            return this;
        }

        public BoltRenderInfo randomFunction(RandomFunction randomFunction) {
            this.randomFunction = randomFunction;
            return this;
        }

        public BoltRenderInfo spreadFunction(SpreadFunction spreadFunction) {
            this.spreadFunction = spreadFunction;
            return this;
        }

        public BoltRenderInfo color(Color color) {
            this.color = color;
            return this;
        }
    }

    public static interface SpawnFunction {
        public static final SpawnFunction NO_DELAY = rand -> new SpawnDelayBounds(0.0f, 0.0f);
        public static final SpawnFunction CONSECUTIVE = new SpawnFunction(){

            @Override
            public SpawnDelayBounds getSpawnDelayBounds(Random rand) {
                return new SpawnDelayBounds(0.0f, 0.0f);
            }

            @Override
            public boolean isConsecutive() {
                return true;
            }
        };

        public static SpawnFunction delay(float delay) {
            return rand -> new SpawnDelayBounds(delay, delay);
        }

        public static SpawnFunction noise(float delay, float noise) {
            return rand -> new SpawnDelayBounds(delay - noise, delay + noise);
        }

        public SpawnDelayBounds getSpawnDelayBounds(Random var1);

        default public float getSpawnDelay(Random rand) {
            SpawnDelayBounds bounds = this.getSpawnDelayBounds(rand);
            return Mth.m_14179_((float)rand.nextFloat(), (float)bounds.start(), (float)bounds.end());
        }

        default public boolean isConsecutive() {
            return false;
        }

        public record SpawnDelayBounds(float start, float end) {
        }
    }

    public static interface FadeFunction {
        public static final FadeFunction NONE = (totalBolts, lifeScale) -> new RenderBounds(0, totalBolts);

        public static FadeFunction fade(float fade) {
            return (totalBolts, lifeScale) -> {
                int start = lifeScale > 1.0f - fade ? (int)((float)totalBolts * (lifeScale - (1.0f - fade)) / fade) : 0;
                int end = lifeScale < fade ? (int)((float)totalBolts * (lifeScale / fade)) : totalBolts;
                return new RenderBounds(start, end);
            };
        }

        public RenderBounds getRenderBounds(int var1, float var2);

        public record RenderBounds(int start, int end) {
        }
    }

    protected record BoltInstructions(Vec3 start, float progress, Vec3 perpendicularDist, QuadCache cache, boolean isBranch) {
    }

    private record QuadCache(Vec3 prevEnd, Vec3 prevEndRight, Vec3 prevEndBack) {
    }

    public static interface SpreadFunction {
        public static final SpreadFunction LINEAR_ASCENT = progress -> progress;
        public static final SpreadFunction LINEAR_ASCENT_DESCENT = progress -> (progress - Math.max(0.0f, 2.0f * progress - 1.0f)) / 0.5f;
        public static final SpreadFunction SINE = progress -> (float)Math.sin(Math.PI * (double)progress);

        public float getMaxSpread(float var1);
    }

    public static interface RandomFunction {
        public static final RandomFunction UNIFORM = Random::nextFloat;
        public static final RandomFunction GAUSSIAN = rand -> (float)rand.nextGaussian();

        public float getRandom(Random var1);
    }

    public static interface SegmentSpreader {
        public static final SegmentSpreader NO_MEMORY = (perpendicularDist, randVec, maxDiff, scale, progress, rand) -> randVec.m_82490_((double)maxDiff * rand);

        public static SegmentSpreader memory(float memoryFactor) {
            return (perpendicularDist, randVec, maxDiff, spreadScale, progress, rand) -> {
                double nextDiff = (double)(maxDiff * (1.0f - memoryFactor)) * rand;
                Vec3 cur = randVec.m_82490_(nextDiff);
                double length = (perpendicularDist = perpendicularDist.m_82549_(cur)).m_82553_();
                if (length > (double)maxDiff) {
                    perpendicularDist = perpendicularDist.m_82490_((double)maxDiff / length);
                }
                return perpendicularDist.m_82549_(cur);
            };
        }

        public Vec3 getSegmentAdd(Vec3 var1, Vec3 var2, float var3, float var4, float var5, double var6);
    }

    private record BoltQuadData(BoltQuads quads, QuadCache cache) {
    }

    public static class BoltQuads {
        private final List<Vec3> vecs = new ArrayList<Vec3>();

        protected void addQuad(Vec3 ... quadVecs) {
            Collections.addAll(this.vecs, quadVecs);
        }

        public List<Vec3> getVecs() {
            return this.vecs;
        }
    }
}

