/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private final XpPumpUpgradeConfig xpPumpUpgradeConfig;

    protected XpPumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.xpPumpUpgradeConfig = ((XpPumpUpgradeItem)this.upgradeItem).getXpPumpUpgradeConfig();
    }

    @Override
    public void tick(@Nullable Entity entity, Level world, BlockPos pos) {
        if (entity != null && !(entity instanceof Player) || this.isInCooldown(world)) {
            return;
        }
        if (entity == null) {
            AABB searchBox = new AABB(pos).m_82400_(3.0);
            for (Player player : world.m_6907_()) {
                if (!searchBox.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        } else {
            Player player = (Player)entity;
            this.interactWithPlayer(player);
            this.mendItems(player);
        }
        this.setCooldown(world, 5);
    }

    private void mendItems(Player player) {
        if (Boolean.FALSE.equals(this.xpPumpUpgradeConfig.mendingOn.get()) || !this.shouldMendItems()) {
            return;
        }
        this.getRandomDamagedItemWithMending(player).ifPresent(itemStack -> {
            float xpToTryDrain;
            if (!itemStack.m_41619_() && itemStack.m_41768_() && itemStack.getXpRepairRatio() > 0.0f && (xpToTryDrain = Math.min((float)((Integer)this.xpPumpUpgradeConfig.maxXpPointsPerMending.get()).intValue(), (float)itemStack.m_41773_() / itemStack.getXpRepairRatio())) > 0.0f) {
                this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                    FluidStack drained = fluidHandler.drain(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), IFluidHandler.FluidAction.EXECUTE, false);
                    float xpDrained = XpHelper.liquidToExperience(drained.getAmount());
                    int durabilityToRepair = (int)(xpDrained * itemStack.getXpRepairRatio());
                    itemStack.m_41721_(itemStack.m_41773_() - durabilityToRepair);
                });
            }
        });
    }

    private Optional<ItemStack> getRandomDamagedItemWithMending(Player player) {
        ArrayList<ItemStack> matchingItems = new ArrayList<ItemStack>();
        List<IItemHandler> equipmentHandlers = InventoryHelper.getEquipmentItemHandlersFromPlayer(player);
        for (IItemHandler handler : equipmentHandlers) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack itemStack = handler.getStackInSlot(slot);
                if (!itemStack.m_41768_() || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44962_, (ItemStack)itemStack) <= 0) continue;
                matchingItems.add(itemStack);
            }
        }
        return Util.m_214676_(matchingItems, (RandomSource)player.m_217043_());
    }

    private void interactWithPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if ((direction == AutomationDirection.INPUT || direction == AutomationDirection.KEEP) && (level < player.f_36078_ || level == player.f_36078_ && player.f_36080_ > 0.0f)) {
                this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, level, false);
            } else if ((direction == AutomationDirection.OUTPUT || direction == AutomationDirection.KEEP) && level > player.f_36078_) {
                this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        FluidStack drained = fluidHandler.drain(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (!drained.isEmpty()) {
            player.m_6756_((int)XpHelper.liquidToExperience(drained.getAmount()));
        }
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        int filled = fluidHandler.fill(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (Fluid)ModFluids.XP_STILL.get(), IFluidHandler.FluidAction.EXECUTE, ignoreInOutLimit);
        if (filled > 0) {
            player.m_6756_((int)(-XpHelper.liquidToExperience(filled)));
        }
    }

    public void takeLevelsFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, Math.max(player.f_36078_ - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, player.f_36078_ + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return NBTHelper.getEnumConstant(this.upgrade, "direction", AutomationDirection::fromName).orElse(AutomationDirection.INPUT);
    }

    public void setDirection(AutomationDirection direction) {
        NBTHelper.setEnumConstant(this.upgrade, "direction", direction);
        this.save();
    }

    public void setLevel(int level) {
        NBTHelper.setInteger(this.upgrade, "level", level);
        this.save();
    }

    public int getLevel() {
        return NBTHelper.getInt(this.upgrade, "level").orElse(10);
    }

    public void setLevelsToStore(int levelsToTake) {
        NBTHelper.setInteger(this.upgrade, "levelsToStore", levelsToTake);
        this.save();
    }

    public int getLevelsToStore() {
        return NBTHelper.getInt(this.upgrade, "levelsToStore").orElse(1);
    }

    public void setLevelsToTake(int levelsToGive) {
        NBTHelper.setInteger(this.upgrade, "levelsToTake", levelsToGive);
        this.save();
    }

    public int getLevelsToTake() {
        return NBTHelper.getInt(this.upgrade, "levelsToTake").orElse(1);
    }

    public boolean shouldMendItems() {
        return NBTHelper.getBoolean(this.upgrade, "mendItems").orElse(true);
    }

    public void setMendItems(boolean mendItems) {
        NBTHelper.setBoolean(this.upgrade, "mendItems", mendItems);
        this.save();
    }
}

