/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network;

import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.block_network.graph.NetworkGraph;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class Network {
    protected final NetworkGraph graph = new NetworkGraph(this);
    private final String id;
    private BlockPos originPos;
    private boolean didDoInitialScan;

    public Network(BlockPos originPos, String id) {
        this.id = id;
        this.originPos = originPos;
    }

    public void setOriginPos(BlockPos originPos) {
        this.originPos = originPos;
    }

    public String getId() {
        return this.id;
    }

    public NetworkGraphScannerResult scanGraph(Level level, BlockPos pos) {
        return this.graph.scan(level, pos);
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        tag.m_128359_("id", this.id);
        tag.m_128356_("origin", this.originPos.m_121878_());
        return tag;
    }

    public void update(Level level) {
        if (!this.didDoInitialScan) {
            this.didDoInitialScan = true;
            this.scanGraph(level, this.originPos);
        }
        this.graph.getElements().forEach(NetworkElement::update);
    }

    public NetworkElement getElement(BlockPos pos) {
        return this.graph.getElements().stream().filter(p -> p.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    public abstract void onMergedWith(Network var1);

    public abstract ResourceLocation getType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        return this.id.equals(network.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

