/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.impl.RankCommandPredicate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class FTBRanksCommandManager {
    public static FTBRanksCommandManager INSTANCE;
    public final Map<String, RankCommandPredicate> commandMap = new HashMap<String, RankCommandPredicate>();
    public final Map<CommandNode<CommandSourceStack>, RankCommandPredicate> commandNodes = new HashMap<CommandNode<CommandSourceStack>, RankCommandPredicate>();

    public FTBRanksCommandManager(Commands commands) {
        FTBRanks.LOGGER.info("Loading command nodes...");
        try {
            Field field = CommandNode.class.getDeclaredField("requirement");
            field.setAccessible(true);
            this.getCommandNodes((CommandDispatcher<CommandSourceStack>)commands.m_82094_(), "command", field, (CommandNode<CommandSourceStack>)commands.m_82094_().getRoot());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            FTBRanks.LOGGER.error("Reflection failed! Downgrading Java version to 8 might help");
        }
        FTBRanks.LOGGER.info("Loaded " + this.commandMap.size() + " command nodes");
    }

    private void getCommandNodes(CommandDispatcher<CommandSourceStack> dispatcher, String perm, Field field, CommandNode<CommandSourceStack> node) throws Exception {
        for (CommandNode childNode : node.getChildren()) {
            if (childNode.isFork()) continue;
            String nodeName = perm + "." + childNode.getName().replace("*", "all");
            FTBRanks.LOGGER.debug(nodeName);
            RankCommandPredicate predicate = new RankCommandPredicate((CommandNode<CommandSourceStack>)childNode, nodeName);
            field.set(childNode, predicate);
            this.commandMap.put(nodeName, predicate);
            this.commandNodes.put((CommandNode<CommandSourceStack>)childNode, predicate);
            this.getCommandNodes(dispatcher, nodeName, field, (CommandNode<CommandSourceStack>)childNode);
            if (childNode.getRedirect() == null || childNode.getRedirect() == dispatcher.getRoot()) continue;
            predicate.setRedirect(() -> this.commandNodes.get(childNode.getRedirect()));
        }
    }
}

