/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.TickableTile;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.TickablePart;
import codechicken.multipart.block.TileMultipart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class TTickableTile
extends TileMultipart
implements TickableTile {
    private final List<TickablePart> tickingParts = new ArrayList<TickablePart>();

    public TTickableTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TTickableTile) {
            this.tickingParts.clear();
            this.tickingParts.addAll(((TTickableTile)that).tickingParts);
        }
    }

    @Override
    public void bindPart(MultiPart part) {
        super.bindPart(part);
        if (part instanceof TickablePart) {
            TickablePart p = (TickablePart)((Object)part);
            this.tickingParts.add(p);
        }
    }

    @Override
    public void partRemoved(MultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof TickablePart) {
            this.tickingParts.remove(part);
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.tickingParts.clear();
    }

    @Override
    public void tick() {
        this.getCapCache().tick();
        int tickingPartsSize = this.tickingParts.size();
        for (int i = 0; i < tickingPartsSize; ++i) {
            TickablePart part = this.tickingParts.get(i);
            if (((MultiPart)((Object)part)).tile() == null) continue;
            part.tick();
        }
    }
}

