/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.FluidUtils2;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.adastra.common.items.ZipGunItem;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static final long LEAST_DISTRIBUTION_AMOUNT = FluidConstants.fromMillibuckets((long)1L);

    public static void distributeToItems(LivingEntity living) {
        OxygenStorageUtils.streamExtractable(living, LEAST_DISTRIBUTION_AMOUNT).forEach(source -> {
            if (source instanceof IOxygenCharger) {
                IOxygenCharger charger = (IOxygenCharger)source;
                OxygenChargerUtils.distributeToItems(living, charger);
            }
        });
    }

    public static void distributeToItems(LivingEntity living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        ItemFluidContainer itemFluidContainer;
        ItemStackReference itemRef;
        Item item;
        FluidContainer fluidContainer = oxygenCharger.getFluidContainer();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().m_41720_()) instanceof SpaceSuitItem) && !(item instanceof ZipGunItem) || (itemFluidContainer = FluidContainer.of((ItemStackHolder)itemRef)) == null || (moved = FluidUtils2.moveFluidAny(fluidContainer, (FluidContainer)itemFluidContainer, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        Item item2 = item.getStack().m_41720_();
        if (item2 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)item2;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

