/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.Trainer_Block;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.Trainer_Handler;
import net.tarantel.chickenroost.item.base.AnimatedChicken_1;
import net.tarantel.chickenroost.item.base.AnimatedChicken_2;
import net.tarantel.chickenroost.item.base.AnimatedChicken_3;
import net.tarantel.chickenroost.item.base.AnimatedChicken_4;
import net.tarantel.chickenroost.item.base.AnimatedChicken_5;
import net.tarantel.chickenroost.item.base.AnimatedChicken_6;
import net.tarantel.chickenroost.item.base.AnimatedChicken_7;
import net.tarantel.chickenroost.item.base.AnimatedChicken_8;
import net.tarantel.chickenroost.item.base.AnimatedChicken_9;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.WrappedHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class Trainer_Tile
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            Trainer_Tile.this.m_6596_();
            if (!Trainer_Tile.this.f_58857_.m_5776_()) {
                Trainer_Tile.this.f_58857_.m_7260_(Trainer_Tile.this.m_58899_(), Trainer_Tile.this.m_58900_(), Trainer_Tile.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            if (slot == 1) {
                return 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.m_41720_() instanceof AnimatedChicken_1 || stack.m_41720_() instanceof AnimatedChicken_2 || stack.m_41720_() instanceof AnimatedChicken_3 || stack.m_41720_() instanceof AnimatedChicken_4 || stack.m_41720_() instanceof AnimatedChicken_5 || stack.m_41720_() instanceof AnimatedChicken_6 || stack.m_41720_() instanceof AnimatedChicken_7 || stack.m_41720_() instanceof AnimatedChicken_8 || stack.m_41720_() instanceof AnimatedChicken_9) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:seeds/tiered"))) || stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:seeds")))) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final RawAnimation CRAFTING = RawAnimation.begin().then("training", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = (Integer)Config.training_speed_tick.get() * 20;
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = new HashMap<Direction, LazyOptional<WrappedHandler>>();
    public static ItemStack MyChicken;
    public static ChickenSeedBase FoodItem;
    public static ChickenItemBase ChickenItem;
    public static int[] LevelList;
    public static int[] XPList;
    public static int[] XPAmountList;

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        AnimationController controller = state.getController();
        controller.triggerableAnim("craft", CRAFTING);
        controller.triggerableAnim("idle", IDLE);
        return PlayState.CONTINUE;
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).m_41619_() ? this.itemHandler.getStackInSlot(0) : ItemStack.f_41583_;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Trainer_Tile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAINER.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> Trainer_Tile.this.progress;
                    case 1 -> Trainer_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        Trainer_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Trainer_Tile.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"name.chicken_roost.trainer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new Trainer_Handler(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            for (Direction direction : Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP)) {
                this.directionWrappedHandlerMap.put(direction, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 0 || index == 1, (index, stack) -> this.itemHandler.isItemValid(0, stack) || this.itemHandler.isItemValid(1, stack))));
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Trainer_Block.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.m_6596_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("trainer.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("trainer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.TRAINER.get());
        CompoundTag nbt = new CompoundTag();
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)itemsTag);
        itemStack.m_41751_(nbt);
        SimpleContainer block = new SimpleContainer(1);
        block.m_6836_(0, itemStack.m_41777_());
        Containers.m_19002_((Level)Objects.requireNonNull(this.f_58857_), (BlockPos)this.f_58858_, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Trainer_Tile pEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (pEntity.itemHandler.getStackInSlot(0).m_41720_().m_5456_() instanceof ChickenItemBase && pEntity.itemHandler.getStackInSlot(1).m_41720_().m_5456_() instanceof ChickenSeedBase) {
            ChickenItem = (ChickenItemBase)pEntity.itemHandler.getStackInSlot(0).m_41720_();
            MyChicken = pEntity.itemHandler.getStackInSlot(0);
            FoodItem = (ChickenSeedBase)pEntity.itemHandler.getStackInSlot(1).m_41720_().m_7968_().m_41720_();
            int ChickenLevel = MyChicken.m_41784_().m_128451_("roost_lvl");
            if (ChickenLevel < LevelList[Trainer_Tile.ChickenItem.currentchickena]) {
                ++pEntity.progress;
                pEntity.triggerAnim("controller", "craft");
                if (pEntity.progress >= pEntity.maxProgress) {
                    Trainer_Tile.craftItem(pEntity);
                }
            }
        } else {
            pEntity.resetProgress();
            pEntity.triggerAnim("controller", "idle");
            Trainer_Tile.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Trainer_Tile pEntity) {
        ChickenItem = (ChickenItemBase)pEntity.itemHandler.getStackInSlot(0).m_41720_();
        MyChicken = pEntity.itemHandler.getStackInSlot(0);
        FoodItem = (ChickenSeedBase)pEntity.itemHandler.getStackInSlot(1).m_41720_().m_7968_().m_41720_();
        Level level = pEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, pEntity.itemHandler.getStackInSlot(i));
        }
        int ChickenXP = MyChicken.m_41784_().m_128451_("roost_xp");
        if (pEntity.itemHandler.getStackInSlot(0).m_41720_() instanceof ChickenItemBase) {
            if (MyChicken.m_41784_().m_128451_("roost_lvl") < LevelList[Trainer_Tile.ChickenItem.currentchickena]) {
                if (pEntity.itemHandler.getStackInSlot(1).m_41720_() instanceof ChickenSeedBase) {
                    if (ChickenXP + XPAmountList[ChickenSeedBase.currentmaxxpp] / 10 >= XPList[Trainer_Tile.ChickenItem.currentchickena]) {
                        MyChicken.m_41784_().m_128405_("roost_lvl", MyChicken.m_41784_().m_128451_("roost_lvl") + 1);
                        MyChicken.m_41784_().m_128405_("roost_xp", 0);
                    } else {
                        MyChicken.m_41784_().m_128405_("roost_xp", ChickenXP + XPAmountList[ChickenSeedBase.currentmaxxpp]);
                    }
                }
                pEntity.itemHandler.extractItem(1, 1, false);
                pEntity.itemHandler.extractItem(0, 0, false);
                pEntity.itemHandler.setStackInSlot(0, MyChicken);
                pEntity.resetProgress();
            } else {
                pEntity.resetProgress();
            }
        }
    }

    private static boolean hasRecipe(Trainer_Tile entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        return entity.itemHandler.getStackInSlot(0).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:roost/tiered"))) && (entity.itemHandler.getStackInSlot(1).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:seeds/tiered"))) || entity.itemHandler.getStackInSlot(1).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:seeds"))));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    static {
        LevelList = new int[]{(Integer)Config.maxlevel_tier_1.get(), (Integer)Config.maxlevel_tier_2.get(), (Integer)Config.maxlevel_tier_3.get(), (Integer)Config.maxlevel_tier_4.get(), (Integer)Config.maxlevel_tier_5.get(), (Integer)Config.maxlevel_tier_6.get(), (Integer)Config.maxlevel_tier_7.get(), (Integer)Config.maxlevel_tier_8.get(), (Integer)Config.maxlevel_tier_9.get()};
        XPList = new int[]{(Integer)Config.xp_tier_1.get(), (Integer)Config.xp_tier_2.get(), (Integer)Config.xp_tier_3.get(), (Integer)Config.xp_tier_4.get(), (Integer)Config.xp_tier_5.get(), (Integer)Config.xp_tier_6.get(), (Integer)Config.xp_tier_7.get(), (Integer)Config.xp_tier_8.get(), (Integer)Config.xp_tier_9.get()};
        XPAmountList = new int[]{(Integer)Config.food_xp_tier_1.get(), (Integer)Config.food_xp_tier_2.get(), (Integer)Config.food_xp_tier_3.get(), (Integer)Config.food_xp_tier_4.get(), (Integer)Config.food_xp_tier_5.get(), (Integer)Config.food_xp_tier_6.get(), (Integer)Config.food_xp_tier_7.get(), (Integer)Config.food_xp_tier_8.get(), (Integer)Config.food_xp_tier_9.get()};
    }
}

