/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUpgrade
extends Item {
    private static int nextGroupId = 0;
    private boolean allowMultiple;
    private final int groupId;

    public ItemUpgrade(Item.Properties properties) {
        this(properties, ItemUpgrade.getNextGroupId());
    }

    protected ItemUpgrade(Item.Properties properties, int groupId) {
        super(properties);
        this.groupId = groupId;
    }

    protected static int getNextGroupId() {
        int groupId = nextGroupId++;
        return groupId;
    }

    public int getUpgradeGroup() {
        return this.groupId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag advanced) {
        ComponentUtil.appendSplitDescription(list, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component m_41466_() {
        return this.isEnabled() ? Component.m_237115_((String)(this.m_5524_() + ".desc")) : Component.m_237115_((String)"itemConfig.storagedrawers.disabled_upgrade").m_130940_(ChatFormatting.RED);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setAllowMultiple(boolean allow) {
        this.allowMultiple = allow;
    }

    public boolean getAllowMultiple() {
        return this.allowMultiple;
    }
}

