/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import java.util.HashSet;
import java.util.Set;
import mrtjp.projectred.api.BlockMover;
import mrtjp.projectred.api.FrameInteraction;
import mrtjp.projectred.api.IExpansionAPI;
import mrtjp.projectred.api.MovementDescriptor;
import mrtjp.projectred.api.MovingBlockEntityRenderCallback;
import mrtjp.projectred.expansion.FrameStickResolver;
import mrtjp.projectred.expansion.MovementManager;
import mrtjp.projectred.expansion.MovementRegistry;
import mrtjp.projectred.expansion.client.MovementClientRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ExpansionAPI
implements IExpansionAPI {
    public static final IExpansionAPI INSTANCE = new ExpansionAPI();

    private ExpansionAPI() {
    }

    public void registerBlockMover(Block block, BlockMover mover) {
        MovementRegistry.registerBlockMover(block, mover);
    }

    public void registerFrameInteraction(FrameInteraction interaction) {
        MovementRegistry.registerFrameInteraction(interaction);
    }

    public void registerBlockEntityRenderCallback(MovingBlockEntityRenderCallback callback) {
        MovementClientRegistry.registerBlockEntityRendererCallback(callback);
    }

    public MovementDescriptor beginMove(Level level, int dir, double speed, Set<BlockPos> blocks) {
        return MovementManager.getInstance(level).beginMove(level, blocks, dir, speed);
    }

    public Set<BlockPos> getStructure(Level level, BlockPos pos, BlockPos ... exclusions) {
        FrameStickResolver resolver = new FrameStickResolver(level, pos, new HashSet<BlockPos>(Set.of(exclusions)));
        return resolver.resolve();
    }

    public boolean isMoving(Level level, BlockPos pos) {
        return MovementManager.getInstance(level).getMovementInfo(pos).isMoving();
    }
}

