/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.client.particle.BaseActionParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

public class PneumaticSmokeParticle
extends BaseActionParticle {
    public static ResourceLocation SMOKE_PARTICLE_LOCATION = new ResourceLocation("projectred_expansion", "textures/particle/smoke.png");
    public static TextureAtlasSprite SMOKE_PARTICLE_SPRITE;
    private static ParticleRenderType PARTICLE_TYPE_SMOKE;
    private final List<Vector3> points = new LinkedList<Vector3>();

    public PneumaticSmokeParticle(ClientLevel pLevel, List<Vector3> points) {
        super(pLevel, points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        this.points.addAll(points);
        this.m_172260_(0.0, 0.0, 0.0);
        this.m_107253_(EnumColour.LIGHT_GRAY.rF(), EnumColour.LIGHT_GRAY.gF(), EnumColour.LIGHT_GRAY.bF());
        this.m_107271_(1.0f);
        this.m_107257_(100);
        this.f_107226_ = 0.0f;
        Cuboid6 bounds = new Cuboid6(this.f_107212_, this.f_107213_, this.f_107214_, this.f_107212_, this.f_107213_, this.f_107214_);
        for (Vector3 point : points) {
            bounds.enclose(point);
        }
        this.m_107259_(bounds.aabb());
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.runActions(pPartialTicks);
        Translation t = new Translation(-pRenderInfo.m_90583_().f_82479_, -pRenderInfo.m_90583_().f_82480_, -pRenderInfo.m_90583_().f_82481_);
        TransformingVertexConsumer vc = new TransformingVertexConsumer(pBuffer, (Transformation)t);
        Vector3 lastPoint = null;
        for (Vector3 point : this.points) {
            if (lastPoint != null) {
                this.drawSmokeLine((VertexConsumer)vc, lastPoint, point, pPartialTicks);
            }
            lastPoint = point;
        }
    }

    private void drawSmokeLine(VertexConsumer buffer, Vector3 p1, Vector3 p2, float f) {
        Transformation[] transforms;
        Vector3 dp = p2.copy().subtract(p1);
        double width = 0.25;
        double length = dp.mag();
        Vector3 quadPoint = new Vector3(0.0, length, 0.0);
        double angle = quadPoint.angle(dp);
        Vector3 axis = quadPoint.copy().crossProduct(dp).normalize();
        Rotation t = new Rotation(angle, axis);
        float slideProg = ((float)this.f_107224_ + f) / (float)this.f_107225_ * 8.0f;
        float u1 = 0.0f;
        float v1 = slideProg;
        float u2 = 1.0f;
        float v2 = v1 + (float)length;
        int j = this.m_6355_(f);
        for (Transformation tf : transforms = new Transformation[]{new TransformationList(new Transformation[]{t, p1.translation()}), new TransformationList(new Transformation[]{Rotation.quarterRotations[1], t, p1.translation()})}) {
            TransformingVertexConsumer bc = new TransformingVertexConsumer(buffer, tf);
            bc.m_5483_(-width, 0.0, 0.0).m_7421_(u1, v2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            bc.m_5483_(-width, length, 0.0).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            bc.m_5483_(width, length, 0.0).m_7421_(u2, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            bc.m_5483_(width, 0.0, 0.0).m_7421_(u2, v2).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        }
    }

    public ParticleRenderType m_7556_() {
        return PARTICLE_TYPE_SMOKE;
    }

    public static void onTextureStitchEvent(TextureStitchEvent.Post event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        SMOKE_PARTICLE_SPRITE = event.getAtlas().m_118316_(new ResourceLocation("projectred_expansion", "particle/smoke"));
    }

    static {
        PARTICLE_TYPE_SMOKE = new ParticleRenderType(){

            public void m_6505_(BufferBuilder buffer, TextureManager textureManager) {
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SMOKE_PARTICLE_LOCATION);
                RenderSystem.enableBlend();
                RenderSystem.disableCull();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            }

            public void m_6294_(Tesselator tesselator) {
                tesselator.m_85914_();
            }

            public String toString() {
                return "PARTICLE_TYPE_SMOKE";
            }
        };
    }
}

