/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.graphs.GraphLink;
import mrtjp.projectred.expansion.graphs.GraphLinkSegment;

public class GraphLinkPathfinder {
    private final Queue<Node> open = new LinkedList<Node>();
    private final HashSet<Node> openSet = new HashSet();
    private final HashSet<Node> closedSet = new HashSet();
    private final List<GraphLink> links = new LinkedList<GraphLink>();
    private final GraphContainer startContainer;

    public GraphLinkPathfinder(GraphContainer startContainer) {
        this.startContainer = startContainer;
        this.openInitial(startContainer);
    }

    private void openInitial(GraphContainer startContainer) {
        for (int s = 0; s < 6; ++s) {
            Node next;
            GraphContainer nextContainer;
            if (!startContainer.canPropagate(s) || (nextContainer = startContainer.getNodeTowards(s)) == null || this.openSet.contains(next = new Node(nextContainer, s ^ 1, s, startContainer.getLinkWeight(), Collections.singletonList(s))) || this.closedSet.contains(next)) continue;
            this.open.add(next);
            this.openSet.add(next);
        }
    }

    private void openNext(Node prev) {
        if (prev.container.getNode().isActive()) {
            this.links.add(new GraphLink(this.startContainer, prev.container, prev.weight, prev.calcSegments()));
            return;
        }
        for (int s = 0; s < 6; ++s) {
            Node next;
            GraphContainer nextContainer;
            if (s == prev.inputDir || !prev.container.canPropagate(s) || (nextContainer = prev.container.getNodeTowards(s)) == null || this.openSet.contains(next = prev.towards(nextContainer, s, prev.container.getLinkWeight())) || this.closedSet.contains(next)) continue;
            this.open.add(next);
            this.openSet.add(next);
        }
    }

    public void step() {
        if (this.open.isEmpty()) {
            return;
        }
        Node next = this.open.poll();
        this.openSet.remove(next);
        this.openNext(next);
        this.closedSet.add(next);
    }

    public boolean isFinished() {
        return this.open.isEmpty();
    }

    public List<GraphLink> result() {
        while (!this.isFinished()) {
            this.step();
        }
        return Collections.unmodifiableList(this.links);
    }

    private static class Node {
        public final GraphContainer container;
        public final int inputDir;
        public final int initialDir;
        public final int weight;
        public final List<Integer> path;

        public Node(GraphContainer container, int inputDir, int initialDir, int weight, List<Integer> path) {
            this.container = container;
            this.inputDir = inputDir;
            this.initialDir = initialDir;
            this.weight = weight;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.inputDir == node.inputDir && this.container == node.container;
        }

        public int hashCode() {
            return Objects.hash(this.container, this.inputDir);
        }

        public Node towards(GraphContainer nextContainer, int dir, int weight) {
            LinkedList<Integer> nextPath = new LinkedList<Integer>(this.path);
            nextPath.add(dir);
            return new Node(nextContainer, dir ^ 1, this.initialDir, this.weight + weight, nextPath);
        }

        public List<GraphLinkSegment> calcSegments() {
            if (this.path.isEmpty()) {
                return Collections.emptyList();
            }
            Iterator<Integer> it = this.path.iterator();
            int dir = it.next();
            int dist = 1;
            LinkedList<GraphLinkSegment> segments = new LinkedList<GraphLinkSegment>();
            while (it.hasNext()) {
                int next = it.next();
                if (next != dir) {
                    segments.add(new GraphLinkSegment(dir, dist));
                    dir = next;
                    dist = 1;
                    continue;
                }
                ++dist;
            }
            segments.add(new GraphLinkSegment(dir, dist));
            return segments;
        }
    }
}

