/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.recipes.Breeder_Recipe;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.Roost_Recipe;
import net.tarantel.chickenroost.recipes.Soul_Extractor_Recipe;
import net.tarantel.chickenroost.recipes.ThrowEggRecipe;
import net.tarantel.chickenroost.recipes.Trainer_Recipe;
import net.tarantel.chickenroost.screen.CustomSlot;
import org.jetbrains.annotations.NotNull;

public class Guide_Screen
extends Screen {
    private List<Button> menuButtons = new ArrayList<Button>();
    private String currentContent = "";
    private List<? extends Recipe<?>> recipes;
    private int scrollOffset = 0;
    private RecipeType<?> currentRecipeType;
    public int customindex = 99;
    private static final ResourceLocation SLOT = new ResourceLocation("chicken_roost", "textures/screens/slot.png");
    private static final ResourceLocation ARROW = new ResourceLocation("chicken_roost", "textures/screens/arrow.png");

    public Guide_Screen() {
        super((Component)Component.m_237113_((String)""));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        int menuWidth = 150;
        int menuMargin = 10;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        String[] menuItems = new String[]{"Start", "Roost Recipes", "Breeder Recipes", "Soul Extractor", "Trainer", "Colored Chicken"};
        for (int i = 0; i < menuItems.length; ++i) {
            int buttonY = menuMargin + i * (buttonHeight + buttonSpacing);
            int menuIndex = i;
            Button button2 = Button.m_253074_((Component)Component.m_237113_((String)menuItems[i]), buttonWidget -> this.onMenuButtonClick(menuIndex)).m_252987_(menuMargin, buttonY, menuWidth - 2 * menuMargin, buttonHeight).m_253136_();
            this.menuButtons.add(button2);
            this.m_142416_((GuiEventListener)button2);
        }
        int closeButtonWidth = 100;
        int closeButtonHeight = 20;
        int closeMargin = 10;
        int closeX = this.f_96543_ - closeButtonWidth - closeMargin;
        int closeY = this.f_96544_ - closeButtonHeight - closeMargin;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()).m_252987_(closeX, closeY, closeButtonWidth, closeButtonHeight).m_253136_());
        int scrollButtonWidth = 20;
        int scrollButtonHeight = 20;
        int scrollButtonX = this.f_96543_ - scrollButtonWidth - 10;
        int scrollButtonY = 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), button -> this.scrollUp()).m_252987_(scrollButtonX, scrollButtonY, scrollButtonWidth, scrollButtonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2193"), button -> this.scrollDown()).m_252987_(scrollButtonX, scrollButtonY + scrollButtonHeight + 5, scrollButtonWidth, scrollButtonHeight).m_253136_());
        this.onMenuButtonClick(0);
    }

    public void m_280273_(@NotNull GuiGraphics poseStack) {
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        int contentBoxX = 160;
        int contentBoxY = 10;
        int contentBoxWidth = this.f_96543_ - 180;
        int contentBoxHeight = this.f_96544_ - 60;
        guiGraphics.m_280509_(contentBoxX, contentBoxY, contentBoxX + contentBoxWidth, contentBoxY + contentBoxHeight, -16777216);
        guiGraphics.m_280637_(contentBoxX, contentBoxY, contentBoxWidth, contentBoxHeight, -1);
        guiGraphics.m_280488_(this.f_96547_, this.currentContent, contentBoxX + 10, contentBoxY + 10, 0xFFFFFF);
        int startY = contentBoxY + 30;
        int slotSpacing = 30;
        guiGraphics.m_280588_(contentBoxX, contentBoxY + 25, contentBoxX + contentBoxWidth, contentBoxY + contentBoxHeight - 5);
        if (this.currentRecipeType != null) {
            for (int i = 0; i < this.recipes.size(); ++i) {
                ItemStack input1;
                int temp;
                Recipe<?> recipe = this.recipes.get(i);
                int ingredientCount = recipe.m_7527_().size();
                int slotX1 = contentBoxX + 10;
                int slotX2 = slotX1 + (ingredientCount > 1 ? 40 : 0);
                int slotX3 = slotX2 + (ingredientCount > 2 ? 40 : 0);
                int outputSlotX = slotX3 + 40 + (ingredientCount > 2 ? 60 : 40);
                int slotY = startY + i * slotSpacing - this.scrollOffset;
                int backgroundWidth = outputSlotX + 20 - slotX1;
                guiGraphics.m_280509_(slotX1 - 5, slotY - 5, slotX1 + backgroundWidth + 5, slotY + 25, -2136298838);
                if (this.currentRecipeType == ModRecipes.ROOST_TYPE.get() || this.currentRecipeType == ModRecipes.BASIC_BREEDING_TYPE.get()) {
                    temp = slotX1;
                    slotX1 = slotX2;
                    slotX2 = temp;
                }
                if (this.currentRecipeType == ModRecipes.TRAINER_TYPE.get()) {
                    temp = slotX1;
                    slotX1 = outputSlotX;
                    outputSlotX = temp;
                }
                if (!(input1 = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0]).m_41619_() && !input1.m_41619_()) {
                    guiGraphics.m_280480_(input1, slotX1, slotY);
                }
                ItemStack input2 = ItemStack.f_41583_;
                if (ingredientCount > 1 && !(input2 = ((Ingredient)recipe.m_7527_().get(1)).m_43908_()[0]).m_41619_()) {
                    guiGraphics.m_280480_(input2, slotX2, slotY);
                }
                ItemStack input3 = ItemStack.f_41583_;
                if (ingredientCount > 2 && !(input3 = ((Ingredient)recipe.m_7527_().get(2)).m_43908_()[0]).m_41619_()) {
                    guiGraphics.m_280480_(input3, slotX3, slotY);
                }
                int arrowX = slotX3 + (ingredientCount > 2 ? 40 : 20);
                int arrowY = slotY + 2;
                guiGraphics.m_280163_(ARROW, arrowX, arrowY, 0.0f, 0.0f, 40, 10, 40, 10);
                ItemStack output = recipe.m_8043_(null);
                if (!output.m_41619_()) {
                    guiGraphics.m_280480_(output, outputSlotX, slotY);
                }
                for (Renderable widget : this.f_169369_) {
                    ItemStack stack;
                    CustomSlot slot;
                    if (!(widget instanceof CustomSlot) || !(slot = (CustomSlot)widget).m_280329_() || (stack = slot.m_7993_()).m_41619_()) continue;
                    guiGraphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
                }
                if (this.isHovering(slotX1, slotY, 16, 16, mouseX, mouseY) && !input1.m_41619_()) {
                    guiGraphics.m_280153_(this.f_96547_, input1, mouseX, mouseY);
                }
                if (this.isHovering(slotX2, slotY, 16, 16, mouseX, mouseY) && !input2.m_41619_()) {
                    guiGraphics.m_280153_(this.f_96547_, input2, mouseX, mouseY);
                }
                if (this.isHovering(slotX3, slotY, 16, 16, mouseX, mouseY) && !input3.m_41619_()) {
                    guiGraphics.m_280153_(this.f_96547_, input3, mouseX, mouseY);
                }
                if (this.isHovering(outputSlotX, slotY, 16, 16, mouseX, mouseY) && !output.m_41619_()) {
                    guiGraphics.m_280153_(this.f_96547_, output, mouseX, mouseY);
                }
                guiGraphics.m_280163_(SLOT, slotX1 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                if (!input2.m_41619_()) {
                    guiGraphics.m_280163_(SLOT, slotX2 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                if (!input3.m_41619_()) {
                    guiGraphics.m_280163_(SLOT, slotX3 - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
                }
                guiGraphics.m_280163_(SLOT, outputSlotX - 2, slotY - 2, 0.0f, 0.0f, 20, 20, 20, 20);
            }
        }
        guiGraphics.m_280618_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void addRenderableWidget(CustomSlot slot) {
    }

    private void shuffleArray(ItemStack[] array) {
        RandomSource random = Minecraft.m_91087_().f_91073_.f_46441_;
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.m_188503_(i + 1);
            ItemStack temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    private void onMenuButtonClick(int menuIndex) {
        Level level = Minecraft.m_91087_().f_91074_.m_9236_();
        RecipeManager recipeManager = level.m_7465_();
        this.scrollOffset = 0;
        if (level == null) {
            return;
        }
        switch (menuIndex) {
            case 0: {
                this.currentContent = "Welcome to the Chicken Roost Guide!";
                this.currentRecipeType = null;
                this.recipes = List.of();
                break;
            }
            case 1: {
                this.currentContent = "Roost Recipes";
                this.currentRecipeType = (RecipeType)ModRecipes.ROOST_TYPE.get();
                this.recipes = recipeManager.m_44013_((RecipeType)Roost_Recipe.Type.INSTANCE).stream().map(recipeHolder -> recipeHolder).toList();
                break;
            }
            case 2: {
                this.currentContent = "Breeder Recipes";
                this.currentRecipeType = (RecipeType)ModRecipes.BASIC_BREEDING_TYPE.get();
                this.recipes = recipeManager.m_44013_((RecipeType)Breeder_Recipe.Type.INSTANCE).stream().map(recipeHolder -> recipeHolder).toList();
                break;
            }
            case 3: {
                this.currentContent = "Soul Extractor Recipes";
                this.currentRecipeType = (RecipeType)ModRecipes.SOUL_EXTRACTION_TYPE.get();
                this.recipes = recipeManager.m_44013_((RecipeType)Soul_Extractor_Recipe.Type.INSTANCE).stream().map(recipeHolder -> recipeHolder).toList();
                break;
            }
            case 4: {
                this.currentContent = "Trainer Recipes";
                this.currentRecipeType = (RecipeType)ModRecipes.TRAINER_TYPE.get();
                this.recipes = recipeManager.m_44013_((RecipeType)Trainer_Recipe.Type.INSTANCE).stream().map(recipeHolder -> recipeHolder).toList();
                break;
            }
            case 5: {
                this.currentContent = "Colored Chicken Recipes";
                this.currentRecipeType = ModRecipes.THROW_EGG_TYPE.get();
                this.recipes = recipeManager.m_44013_((RecipeType)ThrowEggRecipe.Type.INSTANCE).stream().map(recipeHolder -> recipeHolder).toList();
                break;
            }
            default: {
                this.currentContent = "Invalid Menu";
                this.currentRecipeType = null;
                this.recipes = List.of();
            }
        }
    }

    private void scrollUp() {
        this.scrollOffset = Math.max(0, this.scrollOffset - 30);
    }

    private void scrollDown() {
        this.scrollOffset += 30;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (scrollDelta > 0.0) {
            this.scrollUp();
        } else if (scrollDelta < 0.0) {
            this.scrollDown();
        }
        return true;
    }
}

