/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class BoreWarpLensTest {
    private static final String TEMPLATE = "botania:item/lens/bore_warp_relay_interaction";
    private static final BlockPos SPREADER_POS = new BlockPos(2, 2, 1);
    private static final BlockPos SPREADER_TARGET_POS = new BlockPos(5, 2, 1);
    private static final BlockPos BUTTON_POS = new BlockPos(2, 3, 2);
    private static final BlockPos RELAY_POS = new BlockPos(4, 2, 1);
    private static final BlockPos BOUND_POS = new BlockPos(1, 2, 4);
    private static final BlockPos TARGET_BLOCK_POS = new BlockPos(3, 2, 4);
    private static final BlockPos UNWARPED_HOPPER_POS = new BlockPos(3, 1, 4);
    private static final BlockPos WARPED_HOPPER_POS = new BlockPos(1, 1, 1);

    @GameTest(m_177046_="botania:item/lens/bore_warp_relay_interaction", m_177042_=25)
    public void testWarpBoreLens(GameTestHelper helper) {
        BoreWarpLensTest.setUpLensesAndBindings(helper, BotaniaItems.lensWarp, BotaniaItems.lensMine);
        helper.m_177425_().m_177546_(1, () -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177271_(RELAY_POS, block -> block == BotaniaBlocks.pistonRelay, "Force relay was broken");
            helper.m_177357_(TARGET_BLOCK_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Target block was not broken");
            helper.m_177242_(UNWARPED_HOPPER_POS, Items.f_42223_);
            helper.m_177440_(WARPED_HOPPER_POS);
        }).m_177543_();
    }

    @GameTest(m_177046_="botania:item/lens/bore_warp_relay_interaction", m_177042_=25)
    public void testBoreWarpLens(GameTestHelper helper) {
        BoreWarpLensTest.setUpLensesAndBindings(helper, BotaniaItems.lensMine, BotaniaItems.lensWarp);
        helper.m_177425_().m_177546_(1, () -> helper.m_177385_(BUTTON_POS)).m_177552_(() -> helper.m_177255_(BUTTON_POS, (Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false))).m_177562_(() -> {
            helper.m_177271_(RELAY_POS, block -> block == BotaniaBlocks.pistonRelay, "Force relay was broken");
            helper.m_177357_(TARGET_BLOCK_POS, BlockBehaviour.BlockStateBase::m_60795_, () -> "Target block was not broken");
            helper.m_177440_(UNWARPED_HOPPER_POS);
            helper.m_177242_(WARPED_HOPPER_POS, Items.f_42223_);
        }).m_177543_();
    }

    private static void setUpLensesAndBindings(GameTestHelper helper, Item firstLensType, Item secondLensType) {
        TestingUtil.setUpSpreaderAndCompositeLens(helper, firstLensType, secondLensType, SPREADER_POS, SPREADER_TARGET_POS);
        TestingUtil.bindForceRelayTarget(helper, RELAY_POS, BOUND_POS);
    }
}

