/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui.entry;

import com.google.gson.Gson;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.client.config.gui.ConfigScreen;
import io.github.jamalam360.jamlib.client.config.gui.entry.BooleanConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.EnumConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.FieldConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.ListConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.NumberConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.StringConfigEntry;
import io.github.jamalam360.jamlib.client.gui.ScrollingStringWidget;
import io.github.jamalam360.jamlib.client.gui.SpriteButton;
import io.github.jamalam360.jamlib.client.mixinsupport.MutableSpriteImageWidget;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigEntry<T, V> {
    private static final Gson GSON = new Gson();
    protected final ConfigField<T, V> field;
    protected final ConfigManager<T> configManager;
    protected final V originalValue;
    private final String translationKey;
    @Nullable
    private final Component tooltip;
    protected ImageWidget validationIcon;
    @Nullable
    protected List<ConfigExtensions.ValidationError> errors;
    private boolean recreateWidgetsNextTick = false;

    public static <T, V> ConfigEntry<T, V> createFromField(String modId, String configName, Field field) {
        Class<?> c = field.getType();
        if (c == Boolean.TYPE) {
            return new BooleanConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c == Float.TYPE || c == Double.TYPE || c == Integer.TYPE || c == Long.TYPE) {
            return new NumberConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c == String.class) {
            return new StringConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (c.isEnum()) {
            return new EnumConfigEntry(modId, configName, new FieldConfigField(field));
        }
        if (Collection.class.isAssignableFrom(c)) {
            return new ListConfigEntry(modId, configName, new FieldConfigField(field));
        }
        throw new IllegalArgumentException("Unsupported config field type " + String.valueOf(c));
    }

    public ConfigEntry(String modId, String configName, ConfigField<T, V> field) {
        this.field = field;
        this.configManager = ConfigManager.MANAGERS.get(new ConfigManager.Key(modId, configName));
        this.originalValue = this.cloneObject(this.getFieldValue());
        this.translationKey = ConfigScreen.createTranslationKey(modId, configName, field.getName());
        this.tooltip = I18n.m_118936_((String)(this.translationKey + ".tooltip")) ? Component.m_237115_((String)(this.translationKey + ".tooltip")) : null;
    }

    public List<AbstractWidget> createWidgets(int width) {
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int n = 9 / 2 + 1;
        int n2 = width / 2 - 10;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        ScrollingStringWidget title = new ScrollingStringWidget(12, n, n2, 9, (Component)Component.m_237115_((String)this.translationKey), Minecraft.m_91087_().f_91062_);
        if (this.tooltip != null) {
            title.m_257544_(Tooltip.m_257550_((Component)this.tooltip));
        }
        widgets.add((AbstractWidget)title);
        this.validationIcon = new ImageWidget(20, 20, JamLib.id("textures/gui/validation_warning.png"));
        this.validationIcon.m_252865_(width - 212);
        this.validationIcon.m_253211_(0);
        this.validationIcon.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"config.jamlib.requires_restart_tooltip")));
        this.validationIcon.f_93624_ = false;
        widgets.add((AbstractWidget)this.validationIcon);
        widgets.addAll(this.createElementWidgets(width - 188, 150));
        SpriteButton resetButton = new SpriteButton(width - 30, 0, 20, 20, Component.m_237115_((String)"config.jamlib.reset"), JamLib.id("textures/gui/reset.png"), 16, 16, button -> this.reset());
        resetButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"config.jamlib.reset_tooltip")));
        widgets.add((AbstractWidget)resetButton);
        return widgets;
    }

    public abstract List<AbstractWidget> createElementWidgets(int var1, int var2);

    public void onChange() {
        this.validate();
    }

    protected void validate() {
        V newValue = this.getFieldValue();
        if (this.configManager.get() instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)this.configManager.get();
            this.errors = ext.getValidationErrors(this.configManager, new ConfigExtensions.FieldValidationInfo(this.field.getName(), newValue, this.originalValue, this.field.getBackingField()));
            this.errors.sort((o1, o2) -> o2.type().ordinal() - o1.type().ordinal());
            this.updateValidationIcon();
        }
    }

    public void reset() {
        this.setFieldValue(this.getDefaultValue());
    }

    protected void updateValidationIcon() {
        if (this.validationIcon != null) {
            if (this.isValid()) {
                this.validationIcon.f_93624_ = false;
            } else {
                this.validationIcon.f_93624_ = true;
                ((MutableSpriteImageWidget)this.validationIcon).setSprite(this.errors.get(0).type().getTexture());
                this.validationIcon.m_257544_(Tooltip.m_257550_((Component)this.errors.get(0).message()));
            }
        }
    }

    @Nullable
    public List<AbstractWidget> getNewWidgets(int width) {
        if (this.recreateWidgetsNextTick) {
            this.recreateWidgetsNextTick = false;
            return this.createWidgets(width);
        }
        return null;
    }

    public void recreateWidgetsNextTick() {
        this.recreateWidgetsNextTick = true;
    }

    public boolean hasChanged() {
        return this.getFieldValue().equals(this.originalValue);
    }

    public boolean isValid() {
        return this.errors == null || this.errors.stream().noneMatch(e -> e.type() == ConfigExtensions.ValidationError.Type.ERROR);
    }

    public Component getName() {
        return Component.m_237115_((String)this.translationKey);
    }

    protected V getFieldValue() {
        return this.field.getValue(this.configManager);
    }

    protected void setFieldValue(V v) {
        Object realValue = v;
        if (v instanceof Number) {
            Number n = (Number)v;
            Class<V> c = this.field.getElementType();
            if (c == Double.TYPE || c == Double.class) {
                realValue = n.doubleValue();
            } else if (c == Float.TYPE || c == Float.class) {
                realValue = Float.valueOf(n.floatValue());
            } else if (c == Integer.TYPE || c == Integer.class) {
                realValue = n.intValue();
            } else if (c == Long.TYPE || c == Long.class) {
                realValue = n.longValue();
            }
        }
        this.field.setValue(this.configManager, realValue);
        this.onChange();
    }

    private V getDefaultValue() {
        try {
            T defaultConfig = this.configManager.getConfigClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            return (V)this.field.getBackingField().get(defaultConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get default config for config " + String.valueOf(this.configManager.getConfigClass()), e);
        }
    }

    private V cloneObject(V object) {
        if (object == null) {
            return null;
        }
        return (V)GSON.fromJson(GSON.toJson(object), object.getClass());
    }
}

