/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui.entry;

import io.github.jamalam360.jamlib.client.config.gui.entry.BooleanConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.EnumConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.ListMemberConfigField;
import io.github.jamalam360.jamlib.client.config.gui.entry.NumberConfigEntry;
import io.github.jamalam360.jamlib.client.config.gui.entry.StringConfigEntry;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class ListConfigEntry<T, E>
extends ConfigEntry<T, List<E>> {
    private List<ConfigEntry<T, E>> listMembers;

    public ListConfigEntry(String modId, String configName, ConfigField<T, List<E>> field) {
        super(modId, configName, field);
    }

    @Override
    public List<AbstractWidget> createElementWidgets(int left, int width) {
        this.createListMembers();
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        int currentY = 0;
        int bottom = 0;
        int childWidth = width - 20 - 4;
        int i = 0;
        while (i < this.listMembers.size()) {
            ConfigEntry<T, E> entry = this.listMembers.get(i);
            List<AbstractWidget> entryWidgets = entry.createElementWidgets(left, childWidth);
            for (AbstractWidget widget : entryWidgets) {
                bottom = Math.max(widget.m_264198_().m_274349_(), bottom);
                widget.m_253211_(widget.m_252907_() + currentY);
            }
            int finalI = i++;
            widgets.add((AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> {
                ((List)this.getFieldValue()).remove(finalI);
                this.onChange();
            }).m_253046_(20, 20).m_252794_(left + childWidth + 4, currentY).m_253136_());
            widgets.addAll(entryWidgets);
            currentY += bottom + 4;
        }
        widgets.add((AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
            ((List)this.getFieldValue()).add(this.getDefaultNewValue());
            this.onChange();
        }).m_253046_(width, 20).m_252794_(left, currentY).m_253136_());
        this.updateValidationIcon();
        return widgets;
    }

    private void createListMembers() {
        this.listMembers = new ArrayList<ConfigEntry<T, E>>();
        List list = (List)this.getFieldValue();
        Class elementType = (Class)((ParameterizedType)this.field.getBackingField().getGenericType()).getActualTypeArguments()[0];
        for (int i = 0; i < list.size(); ++i) {
            if (elementType == Boolean.TYPE) {
                this.listMembers.add(new BooleanConfigEntry(this.configManager.getModId(), this.configManager.getConfigName(), new ListMemberConfigField(this.field.getBackingField(), elementType, i)));
                continue;
            }
            if (elementType == Float.TYPE || elementType == Double.TYPE || elementType == Integer.TYPE || elementType == Long.TYPE || elementType == Float.class || elementType == Double.class || elementType == Integer.class || elementType == Long.class) {
                this.listMembers.add(new NumberConfigEntry(this.configManager.getModId(), this.configManager.getConfigName(), new ListMemberConfigField(this.field.getBackingField(), elementType, i)));
                continue;
            }
            if (elementType == String.class) {
                this.listMembers.add(new StringConfigEntry(this.configManager.getModId(), this.configManager.getConfigName(), new ListMemberConfigField(this.field.getBackingField(), elementType, i)));
                continue;
            }
            if (elementType.isEnum()) {
                this.listMembers.add(new EnumConfigEntry(this.configManager.getModId(), this.configManager.getConfigName(), new ListMemberConfigField(this.field.getBackingField(), elementType, i)));
                continue;
            }
            if (Collection.class.isAssignableFrom(elementType)) {
                throw new IllegalArgumentException("Cannot nest collections in config");
            }
            throw new IllegalArgumentException("Unsupported config field type " + String.valueOf(elementType));
        }
    }

    @Override
    public void onChange() {
        super.onChange();
        this.recreateWidgetsNextTick();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.configManager.get() instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)this.configManager.get();
            ArrayList elementErrors = new ArrayList();
            for (ConfigEntry<T, E> entry : this.listMembers) {
                this.errors.addAll(ext.getValidationErrors(this.configManager, new ConfigExtensions.FieldValidationInfo(entry.field.getName(), entry.getFieldValue(), entry.originalValue, entry.field.getBackingField())));
            }
            this.errors.sort((o1, o2) -> o2.type().ordinal() - o1.type().ordinal());
            this.updateValidationIcon();
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.listMembers.stream().allMatch(ConfigEntry::isValid);
    }

    private Object getDefaultNewValue() {
        Class c = (Class)((ParameterizedType)this.field.getBackingField().getGenericType()).getActualTypeArguments()[0];
        if (c == Boolean.TYPE) {
            return false;
        }
        if (c == Float.TYPE || c == Double.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.class || c == Double.class || c == Integer.class || c == Long.class) {
            return 0;
        }
        if (c == String.class) {
            return "";
        }
        if (c.isEnum()) {
            return c.getEnumConstants()[0];
        }
        if (Collection.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Cannot nest collections in config");
        }
        throw new IllegalArgumentException("Unsupported config field type " + String.valueOf(c));
    }
}

