/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.client.model.turtle.ModelTransformer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;

public final class ModelRenderer {
    private ModelRenderer() {
    }

    public static void renderQuads(PoseStack transform, VertexConsumer buffer, List<BakedQuad> quads, int lightmapCoord, int overlayLight, int @Nullable [] tints) {
        PoseStack.Pose matrix = transform.m_85850_();
        boolean inverted = matrix.m_252922_().determinant() < 0.0f;
        for (BakedQuad bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.m_111304_() && (idx = bakedquad.m_111305_()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.m_111305_()];
            }
            float r = (float)(tint >> 16 & 0xFF) / 255.0f;
            float g = (float)(tint >> 8 & 0xFF) / 255.0f;
            float b = (float)(tint & 0xFF) / 255.0f;
            ModelRenderer.putBulkQuad(buffer, matrix, bakedquad, r, g, b, lightmapCoord, overlayLight, inverted);
        }
    }

    private static void putBulkQuad(VertexConsumer buffer, PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, int lightmapCoord, int overlayLight, boolean invert) {
        Matrix4f matrix = pose.m_252922_();
        Vec3i dirNormal = quad.m_111306_().m_122436_();
        Vector4f vector = new Vector4f();
        matrix.transform((float)dirNormal.m_123341_(), (float)dirNormal.m_123342_(), (float)dirNormal.m_123343_(), 0.0f, vector).normalize();
        float normalX = vector.x();
        float normalY = vector.y();
        float normalZ = vector.z();
        int[] vertices = quad.m_111303_();
        for (int vertex = 0; vertex < 4; ++vertex) {
            int i = ModelTransformer.getVertexOffset(vertex, invert);
            float x = Float.intBitsToFloat(vertices[i]);
            float y = Float.intBitsToFloat(vertices[i + 1]);
            float z = Float.intBitsToFloat(vertices[i + 2]);
            matrix.transform(x, y, z, 1.0f, vector);
            float u = Float.intBitsToFloat(vertices[i + 4]);
            float v = Float.intBitsToFloat(vertices[i + 5]);
            buffer.m_5954_(vector.x(), vector.y(), vector.z(), red, green, blue, 1.0f, u, v, overlayLight, lightmapCoord, normalX, normalY, normalZ);
        }
    }
}

