/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIIngredientHelper;
import me.shedaniel.rei.jeicompat.unwrap.JEIIngredientRenderer;
import me.shedaniel.rei.jeicompat.wrap.JEITypedIngredient;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public enum JEIIngredientManager implements IIngredientManager
{
    INSTANCE;


    @Override
    @NotNull
    public <V> Collection<V> getAllIngredients(@NotNull IIngredientType<V> ingredientType) {
        EntryType definition = JEIPluginDetector.unwrapType(ingredientType);
        return EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack != null && Objects.equals(stack.getType(), definition)).map(EntryStack::cast).map(JEIPluginDetector::jeiValue).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public <V> IIngredientHelper<V> getIngredientHelper(@NotNull V ingredient) {
        return new JEIIngredientHelper(JEIPluginDetector.unwrapDefinition(ingredient).cast());
    }

    @Override
    @NotNull
    public <V> IIngredientHelper<V> getIngredientHelper(@NotNull IIngredientType<V> ingredientType) {
        return new JEIIngredientHelper(JEIPluginDetector.unwrapDefinition(ingredientType).cast());
    }

    @Override
    @NotNull
    public <V> IIngredientRenderer<V> getIngredientRenderer(@NotNull V ingredient) {
        return this.getIngredientRenderer(JEIPluginDetector.jeiType(JEIPluginDetector.unwrapDefinition(ingredient).cast()));
    }

    @Override
    @NotNull
    public <V> IIngredientRenderer<V> getIngredientRenderer(@NotNull IIngredientType<V> ingredientType) {
        return new JEIIngredientRenderer<V>(ingredientType, JEIPluginDetector.unwrapDefinition(ingredientType).cast().getRenderer());
    }

    @Override
    @NotNull
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return CollectionUtils.map((Collection)EntryTypeRegistry.getInstance().values(), definition -> JEIPluginDetector.jeiType(definition));
    }

    @Override
    public <V> void addIngredientsAtRuntime(@NotNull IIngredientType<V> ingredientType, @NotNull Collection<V> ingredients) {
        if (EntryRegistry.getInstance().isReloading()) {
            BasicFilteringRule basic = FilteringRuleTypeRegistry.getInstance().basic();
            for (V ingredient : ingredients) {
                basic.show(JEIPluginDetector.unwrapStack(ingredient, ingredientType));
            }
        }
        EntryRegistry.getInstance().addEntries((Collection)CollectionUtils.map(ingredients, v -> JEIPluginDetector.unwrapStack(v, ingredientType)));
    }

    @Override
    public <V> void removeIngredientsAtRuntime(@NotNull IIngredientType<V> ingredientType, @NotNull Collection<V> ingredients) {
        if (EntryRegistry.getInstance().isReloading()) {
            BasicFilteringRule basic = FilteringRuleTypeRegistry.getInstance().basic();
            for (V ingredient : ingredients) {
                basic.hide(JEIPluginDetector.unwrapStack(ingredient, ingredientType));
            }
        } else {
            LongOpenHashSet hash = new LongOpenHashSet();
            for (V ingredient : ingredients) {
                hash.add(EntryStacks.hashExact(JEIPluginDetector.unwrapStack(ingredient, ingredientType)));
            }
            EntryRegistry.getInstance().removeEntryExactHashIf(arg_0 -> ((LongSet)hash).contains(arg_0));
        }
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(V ingredient) {
        try {
            return Optional.of(JEIPluginDetector.jeiType(JEIPluginDetector.unwrapDefinition(ingredient).cast()));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public <V> Optional<IIngredientType<V>> getIngredientTypeChecked(Class<? extends V> ingredientClass) {
        try {
            return Optional.of(JEIPluginDetector.jeiType(ingredientClass));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public <V> Optional<ITypedIngredient<V>> createTypedIngredient(IIngredientType<V> ingredientType, V ingredient) {
        return Optional.of(new JEITypedIngredient<V>(ingredientType, ingredient));
    }

    @Override
    public <V> Optional<V> getIngredientByUid(IIngredientType<V> ingredientType, String ingredientUuid) {
        ResourceLocation id = new ResourceLocation(ingredientUuid);
        EntryType type = JEIPluginDetector.unwrapType(ingredientType);
        return EntryRegistry.getInstance().getEntryStacks().filter(stack -> stack.getType() == type).filter(stack -> stack.getIdentifier().equals((Object)id)).findFirst().map(EntryStack::castValue);
    }

    @Override
    public void registerIngredientListener(IIngredientManager.IIngredientListener listener) {
        throw JEIPluginDetector.TODO();
    }
}

