/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferError;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferHandler;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferRegistration;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeTransferHandlerHelper
implements IRecipeTransferHandlerHelper {
    private final Consumer<Runnable> post;

    public JEIRecipeTransferHandlerHelper(Consumer<Runnable> post) {
        this.post = post;
    }

    @Override
    public IRecipeTransferError createInternalError() {
        return new JEIRecipeTransferError(IRecipeTransferError.Type.INTERNAL, (Component)Component.m_237110_((String)"error.rei.internal.error", (Object[])new Object[]{""}), new HashSet<IRecipeSlotView>());
    }

    @Override
    public IRecipeTransferError createUserErrorWithTooltip(Component tooltipMessage) {
        return new JEIRecipeTransferError(IRecipeTransferError.Type.USER_FACING, tooltipMessage, new HashSet<IRecipeSlotView>());
    }

    @Override
    public IRecipeTransferError createUserErrorForMissingSlots(Component tooltipMessage, Collection<IRecipeSlotView> missingItemSlots) {
        return new JEIRecipeTransferError(IRecipeTransferError.Type.USER_FACING, tooltipMessage, new HashSet<IRecipeSlotView>(missingItemSlots));
    }

    @Override
    public <C extends AbstractContainerMenu, R> IRecipeTransferInfo<C, R> createBasicRecipeTransferInfo(final Class<? extends C> containerClass, final @Nullable MenuType<C> menuType, final RecipeType<R> recipeType, final int recipeSlotStart, final int recipeSlotCount, final int inventorySlotStart, final int inventorySlotCount) {
        return new IRecipeTransferInfo<C, R>(){

            @Override
            public Class<? extends C> getContainerClass() {
                return containerClass;
            }

            @Override
            public Optional<MenuType<C>> getMenuType() {
                return Optional.ofNullable(menuType);
            }

            @Override
            public RecipeType<R> getRecipeType() {
                return recipeType;
            }

            @Override
            public boolean canHandle(C container, R recipe) {
                return this.getContainerClass().isInstance(container);
            }

            @Override
            public List<Slot> getRecipeSlots(C container, R recipe) {
                return IntStream.range(recipeSlotStart, recipeSlotStart + recipeSlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }

            @Override
            public List<Slot> getInventorySlots(C container, R recipe) {
                return IntStream.range(inventorySlotStart, inventorySlotStart + inventorySlotCount).mapToObj(arg_0 -> container.m_38853_(arg_0)).collect(Collectors.toList());
            }
        };
    }

    @Override
    public <C extends AbstractContainerMenu, R> IRecipeTransferHandler<C, R> createUnregisteredRecipeTransferHandler(IRecipeTransferInfo<C, R> info) {
        new JEIRecipeTransferRegistration(this.post).addRecipeTransferHandler(info);
        InternalLogger.getInstance().error("Creating unregistered recipe transfer handler, this is experimental!!: " + JEIPluginDetector.categoryId(info.getRecipeType()) + " " + info.getContainerClass());
        return new JEIRecipeTransferHandler<C, R>(this, info);
    }

    @Override
    public IRecipeSlotsView createRecipeSlotsView(final List<IRecipeSlotView> slotViews) {
        return new IRecipeSlotsView(){
            public List<IRecipeSlotView> slots;
            public Map<RecipeIngredientRole, List<IRecipeSlotView>> slotsRoled;
            {
                this.setSlots(slotViews);
            }

            @Override
            public List<IRecipeSlotView> getSlotViews() {
                return this.slots;
            }

            @Override
            public List<IRecipeSlotView> getSlotViews(RecipeIngredientRole role) {
                return this.slotsRoled.getOrDefault((Object)role, Collections.emptyList());
            }

            @Override
            public Optional<IRecipeSlotView> findSlotByName(String slotName) {
                return this.slots.stream().filter(slot -> Objects.equals(slot.getSlotName().orElse(null), slotName)).findFirst();
            }

            public void setSlots(List<IRecipeSlotView> slots) {
                this.slots = slots;
                this.slotsRoled = slots.stream().collect(Collectors.groupingBy(IRecipeSlotView::getRole));
            }
        };
    }

    @Override
    public boolean recipeTransferHasServerSupport() {
        return ClientHelper.getInstance().canUseMovePackets();
    }
}

