/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.config.widgets;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothConfigButtonEntry
extends AbstractConfigListEntry<Void> {
    private final Button button;
    private final Button deleteButton;
    private final Component displayName;
    private final boolean hasDeleteButton;
    private final boolean wasEdited;

    public ClothConfigButtonEntry(Component displayName, Component fieldName, @Nullable Button.OnPress onPress) {
        this(displayName, fieldName, onPress, null, false);
    }

    public ClothConfigButtonEntry(Component displayName, Component fieldName, Button.OnPress onPress, @Nullable Button.OnPress deletePress, boolean wasEdited) {
        super(fieldName, false);
        this.hasDeleteButton = deletePress != null;
        this.wasEdited = wasEdited;
        int mainButtonWidth = this.hasDeleteButton ? 75 : 100;
        this.button = Button.m_253074_((Component)fieldName, (Button.OnPress)onPress).m_253046_(mainButtonWidth, 20).m_252794_(0, 0).m_253136_();
        this.deleteButton = deletePress != null ? Button.m_253074_((Component)Component.m_237113_((String)"X"), (Button.OnPress)deletePress).m_253046_(20, 20).m_252794_(0, 0).m_253136_() : null;
        this.displayName = displayName;
    }

    public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Window window = Minecraft.m_91087_().m_91268_();
        Component displayedFieldName = this.displayName;
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            matrices.m_280648_(Minecraft.m_91087_().f_91062_, displayedFieldName.m_7532_(), window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName), y + 6, 0xFFFFFF);
            this.button.m_252865_(x);
            if (this.hasDeleteButton) {
                this.deleteButton.m_252865_(x + this.button.m_5711_() + 4);
            }
        } else {
            matrices.m_280648_(Minecraft.m_91087_().f_91062_, displayedFieldName.m_7532_(), x, y + 6, this.getPreferredTextColor());
            if (this.hasDeleteButton) {
                this.button.m_252865_(x + entryWidth - this.button.m_5711_() - 24);
                this.deleteButton.m_252865_(x + entryWidth - 20);
            } else {
                this.button.m_252865_(x + entryWidth - this.button.m_5711_());
            }
        }
        this.button.m_253211_(y + (entryHeight - 20) / 2);
        this.button.m_88315_(matrices, mouseX, mouseY, delta);
        if (this.hasDeleteButton) {
            this.deleteButton.m_253211_(y + (entryHeight - 20) / 2);
            this.deleteButton.m_88315_(matrices, mouseX, mouseY, delta);
        }
    }

    public Void getValue() {
        return null;
    }

    public Optional<Void> getDefaultValue() {
        return Optional.empty();
    }

    public void save() {
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        ArrayList<Button> children = new ArrayList<Button>();
        children.add(this.button);
        if (this.hasDeleteButton) {
            children.add(this.deleteButton);
        }
        return children;
    }

    public List<? extends NarratableEntry> narratables() {
        ArrayList<Button> children = new ArrayList<Button>();
        children.add(this.button);
        if (this.hasDeleteButton) {
            children.add(this.deleteButton);
        }
        return children;
    }

    public boolean isEdited() {
        return this.wasEdited;
    }
}

