/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="oc2r", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModShaders {
    public static final int MAX_PROJECTORS = 3;
    private static final ResourceLocation PROJECTORS_SHADER_LOCATION = new ResourceLocation("oc2r", "projectors");
    private static final String[] PROJECTOR_COLOR_NAMES = new String[]{"ProjectorColor0", "ProjectorColor1", "ProjectorColor2"};
    private static final String[] PROJECTOR_DEPTH_NAMES = new String[]{"ProjectorDepth0", "ProjectorDepth1", "ProjectorDepth2"};
    private static final String[] PROJECTOR_CAMERA_NAMES = new String[]{"ProjectorCamera0", "ProjectorCamera1", "ProjectorCamera2"};
    private static ShaderInstance projectorsShader;

    @Nullable
    public static ShaderInstance getProjectorsShader() {
        return projectorsShader;
    }

    public static void configureProjectorsShader(RenderTarget target, Matrix4f inverseCameraMatrix, DynamicTexture[] colors, RenderTarget[] depths, Matrix4f[] projectorCameraMatrices, int count) {
        int projectorCount = Math.min(count, 3);
        projectorsShader.m_173356_("Count").m_142617_(projectorCount);
        projectorsShader.m_173350_("MainCameraDepth", (Object)target.m_83980_());
        projectorsShader.m_173356_("InverseMainCamera").m_5679_(inverseCameraMatrix);
        for (int i = 0; i < 3; ++i) {
            if (i < projectorCount) {
                projectorsShader.m_173350_(PROJECTOR_COLOR_NAMES[i], (Object)colors[i].m_117963_());
                projectorsShader.m_173350_(PROJECTOR_DEPTH_NAMES[i], (Object)depths[i].m_83980_());
                projectorsShader.m_173356_(PROJECTOR_CAMERA_NAMES[i]).m_5679_(projectorCameraMatrices[i]);
                continue;
            }
            projectorsShader.m_173350_(PROJECTOR_COLOR_NAMES[i], null);
            projectorsShader.m_173350_(PROJECTOR_DEPTH_NAMES[i], null);
        }
    }

    @SubscribeEvent
    public static void handleRegisterShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), PROJECTORS_SHADER_LOCATION, DefaultVertexFormat.f_85817_), instance -> {
            projectorsShader = instance;
        });
    }
}

