/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.blockentity;

import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.blockentity.BlockEntities;
import li.cil.oc2.common.blockentity.ModBlockEntity;
import li.cil.oc2.common.blockentity.TickableBlockEntity;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.LazyOptionalUtils;
import li.cil.oc2.common.util.LevelUtils;
import li.cil.oc2.common.vxlan.TunnelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public final class VxlanBlockEntity
extends ModBlockEntity
implements NetworkInterface,
TickableBlockEntity {
    private static final int TTL_COST = 1;
    private int vti = 1000;
    private int frameCount;
    private long lastGameTime;
    private final Queue<byte[]> packetQueue = new ArrayBlockingQueue<byte[]>(32);
    private final NetworkInterface[] adjacentBlockInterfaces = new NetworkInterface[Constants.BLOCK_FACE_COUNT + 1];
    private boolean haveAdjacentBlocksChanged = true;

    public VxlanBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.VXLAN_HUB.get(), pos, state);
    }

    public void handleNeighborChanged() {
        this.haveAdjacentBlocksChanged = true;
    }

    @Override
    public byte[] readEthernetFrame() {
        return null;
    }

    @Override
    public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        if (this.f_58857_ == null) {
            return;
        }
        long gameTime = this.f_58857_.m_46467_();
        if (gameTime > this.lastGameTime) {
            this.lastGameTime = gameTime;
            this.frameCount = 1;
        } else {
            if (this.frameCount > Config.hubEthernetFramesPerTick) {
                return;
            }
            ++this.frameCount;
        }
        this.getAdjacentInterfaces().forEach(adjacentInterface -> {
            if (adjacentInterface != source) {
                adjacentInterface.writeEthernetFrame(this, frame, timeToLive - 1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.adjacentBlockInterfaces[0] != null) {
            Queue<byte[]> queue = this.packetQueue;
            synchronized (queue) {
                this.packetQueue.forEach(packet -> this.writeEthernetFrame(this.adjacentBlockInterfaces[0], (byte[])packet, 255));
                this.packetQueue.clear();
            }
        } else {
            System.out.printf("VXLAN block is unregistered upstream: VTI=%d\n", this.vti);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && tag.m_128441_("vti")) {
            this.vti = tag.m_128451_("vti");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            tag.m_128405_("vti", this.vti);
        }
    }

    @Override
    protected void onUnload(boolean isRemove) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.adjacentBlockInterfaces[0] = null;
            TunnelManager.instance().unregisterVti(this.vti);
        }
        super.onUnload(isRemove);
    }

    @Override
    public void loadServer() {
        this.adjacentBlockInterfaces[0] = TunnelManager.instance().registerVti(this.vti, this.packetQueue);
    }

    @Override
    protected void collectCapabilities(ModBlockEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.networkInterface(), this);
    }

    private Stream<NetworkInterface> getAdjacentInterfaces() {
        this.validateAdjacentBlocks();
        return Arrays.stream(this.adjacentBlockInterfaces).filter(Objects::nonNull);
    }

    private void validateAdjacentBlocks() {
        if (this.m_58901_() || !this.haveAdjacentBlocksChanged) {
            return;
        }
        for (Direction side : Constants.DIRECTIONS) {
            this.adjacentBlockInterfaces[side.m_122411_() + 1] = null;
        }
        this.haveAdjacentBlocksChanged = false;
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        BlockPos pos = this.m_58899_();
        for (Direction side : Constants.DIRECTIONS) {
            BlockEntity neighborBlockEntity = LevelUtils.getBlockEntityIfChunkExists((LevelAccessor)this.f_58857_, pos.m_121945_(side));
            if (neighborBlockEntity == null) continue;
            LazyOptional optional = neighborBlockEntity.getCapability(Capabilities.networkInterface(), side.m_122424_());
            optional.ifPresent(adjacentInterface -> {
                this.adjacentBlockInterfaces[side.m_122411_() + 1] = adjacentInterface;
                LazyOptionalUtils.addWeakListener(optional, this, (hub, unused) -> hub.handleNeighborChanged());
            });
        }
    }
}

