/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.inet;

import java.nio.ByteBuffer;
import java.util.Random;
import li.cil.oc2.api.inet.session.Session;
import li.cil.oc2.api.inet.session.StreamSession;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.inet.SessionActions;
import li.cil.oc2.common.inet.SessionBase;
import li.cil.oc2.common.inet.StreamSessionDiscriminator;
import li.cil.oc2.common.inet.TcpHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamSessionImpl
extends SessionBase
implements StreamSession {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random random = new Random();
    private final StreamSessionDiscriminator discriminator;
    private final ByteBuffer receiveBuffer = ByteBuffer.allocate(Config.streamBufferSize);
    private int vmWindow = 0;
    private int nextSegmentMark = 0;
    private final ByteBuffer sendBuffer = ByteBuffer.allocate(Config.streamBufferSize);
    private int mySequence = random.nextInt();
    private int vmSequence;
    private final TcpHeader header = new TcpHeader();
    private TcpStates state = TcpStates.CONNECT;
    private boolean needsAcknowledgment = false;

    public StreamSessionImpl(int ipAddress, short port, StreamSessionDiscriminator discriminator) {
        super(ipAddress, port);
        this.discriminator = discriminator;
        this.sendBuffer.limit(0);
    }

    public SessionActions receive(ByteBuffer segment) {
        return this.state.receive(this, segment);
    }

    public SessionActions send(ByteBuffer segment) {
        return this.state.send(this, segment);
    }

    boolean isNeedsAcknowledgment() {
        return this.needsAcknowledgment;
    }

    @Override
    public ByteBuffer getReceiveBuffer() {
        switch (this.state) {
            case EXPIRED: 
            case FINISH: 
            case REJECT: {
                throw new IllegalStateException();
            }
        }
        return this.receiveBuffer;
    }

    @Override
    public ByteBuffer getSendBuffer() {
        switch (this.state) {
            case EXPIRED: 
            case REJECT: {
                throw new IllegalStateException();
            }
        }
        return this.sendBuffer;
    }

    public StreamSessionDiscriminator getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public void expire() {
        this.state = TcpStates.EXPIRED;
    }

    @Override
    public void connect() {
        if (this.state != TcpStates.CONNECT) {
            throw new IllegalStateException();
        }
        this.state = TcpStates.ACCEPT;
    }

    @Override
    public Session.States getState() {
        return this.state.toSessionState();
    }

    @Override
    public void close() {
        this.state = switch (this.state) {
            case TcpStates.ESTABLISHED -> TcpStates.FINISH;
            case TcpStates.CONNECT -> TcpStates.REJECT;
            default -> throw new IllegalStateException();
        };
    }

    public TcpHeader getHeader() {
        return this.header;
    }

    public String toString() {
        return "StreamSession(" + this.discriminator + ")";
    }

    private int computeWindow() {
        return this.sendBuffer.capacity() - this.sendBuffer.limit();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TcpStates {
        CONNECT{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                LOGGER.warn("Incorrect session layer implementation. Stream session is not updated.");
                return SessionActions.IGNORE;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                if (!header.read(segment)) {
                    return SessionActions.DROP;
                }
                if (!header.isConnectionInitiation()) {
                    return SessionActions.DROP;
                }
                session.vmSequence = header.sequenceNumber;
                session.vmWindow = header.window;
                return SessionActions.FORWARD;
            }

            @Override
            Session.States toSessionState() {
                return Session.States.NEW;
            }
        }
        ,
        ACCEPT{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                header.acceptConnection(session.mySequence, session.vmSequence + 1, session.computeWindow());
                header.write(segment);
                segment.flip();
                return SessionActions.FORWARD;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                if (!header.read(segment)) {
                    return SessionActions.IGNORE;
                }
                if (!header.isAcceptanceOrRejectionAcknowledged()) {
                    return SessionActions.IGNORE;
                }
                ++session.mySequence;
                ++session.vmSequence;
                session.state = ESTABLISHED;
                session.vmWindow = header.window;
                return SessionActions.IGNORE;
            }

            @Override
            Session.States toSessionState() {
                return Session.States.ESTABLISHED;
            }
        }
        ,
        REJECT{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                header.rejectConnection(session.mySequence, session.vmSequence + 1);
                header.write(segment);
                segment.flip();
                return SessionActions.FORWARD;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                throw new IllegalStateException();
            }

            @Override
            Session.States toSessionState() {
                return Session.States.REJECT;
            }
        }
        ,
        ESTABLISHED{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                ByteBuffer receiveBuffer = session.receiveBuffer;
                if (session.nextSegmentMark == 0) {
                    session.nextSegmentMark = Math.min(Math.min(session.vmWindow, receiveBuffer.position()), segment.remaining() - 16);
                    LOGGER.trace("Next segment mark: {}", (Object)session.nextSegmentMark);
                }
                header.urg = false;
                header.syn = false;
                header.rst = false;
                header.ack = true;
                header.sequenceNumber = session.mySequence;
                header.acknowledgmentNumber = session.vmSequence;
                header.maxSegmentSize = -1;
                header.urgentPointer = 0;
                header.psh = session.nextSegmentMark != 0;
                header.window = session.computeWindow();
                if (!header.ack && !header.psh && session.state != FINISH) {
                    LOGGER.trace("Established session nothing to send");
                    return SessionActions.IGNORE;
                }
                if (header.psh) {
                    header.fin = false;
                    header.write(segment);
                    int recvPos = receiveBuffer.position();
                    int recvLim = receiveBuffer.limit();
                    receiveBuffer.limit(session.nextSegmentMark);
                    receiveBuffer.position(0);
                    segment.put(receiveBuffer);
                    receiveBuffer.limit(recvLim);
                    receiveBuffer.position(recvPos);
                } else {
                    header.fin = session.state == FINISH;
                    header.write(segment);
                }
                segment.flip();
                return SessionActions.FORWARD;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                TcpHeader header = session.header;
                boolean correct = header.read(segment);
                if (!correct) {
                    LOGGER.trace("Got invalid TCP header");
                    return SessionActions.IGNORE;
                }
                if (header.syn) {
                    LOGGER.trace("Got syn on established connection");
                    return SessionActions.IGNORE;
                }
                if (header.sequenceNumber != session.vmSequence) {
                    LOGGER.trace("VM sent invalid sequence number (expected {}, got {})", (Object)session.vmSequence, (Object)header.sequenceNumber);
                    return SessionActions.IGNORE;
                }
                int length = segment.remaining();
                if (header.psh && length > session.computeWindow()) {
                    LOGGER.info("Received length > window size");
                    return SessionActions.IGNORE;
                }
                if (header.ack) {
                    if (header.acknowledgmentNumber != session.mySequence + session.nextSegmentMark) {
                        LOGGER.trace("VM acked wrong number (expected {}, got {})", (Object)session.mySequence, (Object)header.acknowledgmentNumber);
                        return SessionActions.IGNORE;
                    }
                    if (header.acknowledgmentNumber == session.mySequence + session.nextSegmentMark) {
                        ByteBuffer receiveBuffer = session.receiveBuffer;
                        int newPosition = receiveBuffer.position() - session.nextSegmentMark;
                        receiveBuffer.position(session.nextSegmentMark);
                        receiveBuffer.compact();
                        receiveBuffer.position(newPosition);
                        receiveBuffer.limit(receiveBuffer.capacity());
                        session.mySequence += session.nextSegmentMark;
                        session.nextSegmentMark = 0;
                    }
                }
                session.vmWindow = header.window;
                if (header.psh) {
                    session.vmSequence += length;
                    ByteBuffer sendBuffer = session.sendBuffer;
                    sendBuffer.compact();
                    sendBuffer.put(segment);
                    sendBuffer.flip();
                    session.needsAcknowledgment = true;
                }
                if (header.fin) {
                    ++session.vmSequence;
                    session.state = FINISH;
                }
                return SessionActions.FORWARD;
            }

            @Override
            Session.States toSessionState() {
                return Session.States.ESTABLISHED;
            }
        }
        ,
        FINISH{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                return SessionActions.DROP;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                return SessionActions.DROP;
            }

            @Override
            Session.States toSessionState() {
                return Session.States.FINISH;
            }
        }
        ,
        EXPIRED{

            @Override
            SessionActions receive(StreamSessionImpl session, ByteBuffer segment) {
                return SessionActions.DROP;
            }

            @Override
            SessionActions send(StreamSessionImpl session, ByteBuffer segment) {
                return SessionActions.DROP;
            }

            @Override
            Session.States toSessionState() {
                return Session.States.EXPIRED;
            }
        };


        abstract SessionActions receive(StreamSessionImpl var1, ByteBuffer var2);

        abstract SessionActions send(StreamSessionImpl var1, ByteBuffer var2);

        abstract Session.States toSessionState();
    }
}

