/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.managed;

import java.util.BitSet;
import java.util.OptionalInt;
import li.cil.oc2.api.bus.device.vm.context.InterruptAllocator;
import li.cil.oc2.common.vm.context.InterruptManager;
import li.cil.oc2.common.vm.context.InterruptValidator;

final class ManagedInterruptAllocator
implements InterruptAllocator,
InterruptValidator {
    private final InterruptAllocator parent;
    private final InterruptManager interruptManager;
    private final BitSet managedInterrupts;
    private final int interruptCount;
    private boolean isFrozen;
    private int managedMask;

    public ManagedInterruptAllocator(InterruptAllocator parent, InterruptManager interruptManager) {
        this.parent = parent;
        this.interruptManager = interruptManager;
        this.interruptCount = interruptManager.getInterruptCount();
        this.managedInterrupts = new BitSet(this.interruptCount);
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void invalidate() {
        this.interruptManager.releaseInterrupts(this.managedInterrupts);
        this.managedInterrupts.clear();
        this.managedMask = 0;
    }

    @Override
    public boolean isMaskValid(int mask) {
        return (mask & ~this.managedMask) == 0;
    }

    @Override
    public int getMaskedInterrupts(int interrupts) {
        return interrupts & this.managedMask;
    }

    @Override
    public boolean claimInterrupt(int interrupt) {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        if (interrupt < 1 || interrupt >= this.interruptCount) {
            throw new IllegalArgumentException();
        }
        if (!this.parent.claimInterrupt(interrupt)) {
            return false;
        }
        this.managedInterrupts.set(interrupt);
        this.managedMask |= 1 << interrupt;
        return true;
    }

    @Override
    public OptionalInt claimInterrupt() {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        OptionalInt result = this.parent.claimInterrupt();
        result.ifPresent(interrupt -> {
            this.managedInterrupts.set(interrupt);
            this.managedMask |= 1 << interrupt;
        });
        return result;
    }
}

