/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public enum DataWriter implements IDataWriter
{
    SERVER(Packets.DATA_RAW, Packets.DATA_TYPED),
    CLIENT(Packets.CTX_RAW, Packets.CTX_TYPED);

    private final ResourceLocation rawPacket;
    private final ResourceLocation typedPacket;
    private final Map<Class<IData>, IData> immediate = new HashMap<Class<IData>, IData>();
    private final Map<Class<IData>, List<Consumer<IDataWriter.Result<IData>>>> lazy = new HashMap<Class<IData>, List<Consumer<IDataWriter.Result<IData>>>>();
    private CompoundTag raw;
    private boolean clean;

    private DataWriter(ResourceLocation rawPacket, ResourceLocation typedPacket) {
        this.rawPacket = rawPacket;
        this.typedPacket = typedPacket;
    }

    public CompoundTag reset() {
        if (this.clean) {
            return this.raw;
        }
        this.raw = new CompoundTag();
        this.clean = true;
        this.immediate.clear();
        this.lazy.values().forEach(List::clear);
        return this.raw;
    }

    public void send(final PacketSender sender, Player player) {
        if (!this.raw.m_128456_()) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.m_130079_(this.raw);
            sender.send(this.rawPacket, buf);
        }
        this.immediate.forEach((type, data) -> {
            block2: {
                try {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.m_130085_(Registrar.get().dataType2Id.get(type));
                    data.write(buf);
                    sender.send(this.typedPacket, buf);
                }
                catch (Throwable t) {
                    if (!ExceptionUtil.dump(t, data.getClass() + "\nplayer " + player.m_6302_(), null)) break block2;
                    player.m_213846_((Component)Component.m_237113_((String)("Error on retrieving data from provider " + data.getClass().getName())));
                }
            }
        });
        this.lazy.forEach((type, data) -> {
            final ResourceLocation id = Registrar.get().dataType2Id.get(type);
            final boolean[] finished = new boolean[]{false};
            for (Consumer consumer : data) {
                try {
                    consumer.accept(new IDataWriter.Result<IData>(){
                        boolean added = false;

                        @Override
                        public IDataWriter.Result<IData> add(IData data) {
                            Preconditions.checkState((!this.added ? 1 : 0) != 0, (Object)"Called multiple times in the same closure");
                            Preconditions.checkNotNull((Object)data, (Object)"Data is null");
                            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                            buf.m_130085_(id);
                            data.write(buf);
                            sender.send(DataWriter.this.typedPacket, buf);
                            finished[0] = true;
                            this.added = true;
                            return this;
                        }

                        @Override
                        public IDataWriter.Result<IData> block() {
                            finished[0] = true;
                            return this;
                        }
                    });
                }
                catch (Throwable t) {
                    if (ExceptionUtil.dump(t, consumer.getClass() + "\nplayer " + player.m_6302_(), null)) {
                        player.m_213846_((Component)Component.m_237113_((String)("Error on retrieving data from provider " + consumer.getClass().getName())));
                    }
                    finished[0] = true;
                }
                if (!finished[0]) continue;
                break;
            }
        });
    }

    @Override
    public CompoundTag raw() {
        this.clean = false;
        return this.raw;
    }

    @Override
    public <T extends IData> void add(Class<T> type, Consumer<IDataWriter.Result<T>> consumer) {
        this.assertType(type);
        this.clean = false;
        this.lazy.computeIfAbsent((Class)TypeUtil.uncheckedCast(type), t -> new ArrayList()).add((Consumer)TypeUtil.uncheckedCast(consumer));
    }

    @Override
    public void addImmediate(IData data) {
        Class<?> type = data.getClass();
        this.assertType(type);
        if (this.lazy.containsKey(type) && !this.lazy.get(type).isEmpty()) {
            throw new IllegalStateException("Data is already lazily added");
        }
        this.clean = false;
        this.immediate.put((Class)TypeUtil.uncheckedCast(type), data);
    }

    public <P, A> void tryAppend(Player player, P provider, A accessor, PluginConfig config, Provider<P, A> fn) {
        block2: {
            try {
                fn.write(provider, this, accessor, config);
            }
            catch (Throwable t) {
                if (!ExceptionUtil.dump(t, provider.getClass() + "\nplayer " + player.m_6302_(), null)) break block2;
                player.m_213846_((Component)Component.m_237113_((String)("Error on retrieving server data from provider " + provider.getClass().getName())));
            }
        }
    }

    private void assertType(Class<? extends IData> type) {
        Preconditions.checkArgument((boolean)Registrar.get().dataType2Id.containsKey(type), (Object)"Data type is not registered");
        Preconditions.checkState((!this.immediate.containsKey(type) ? 1 : 0) != 0, (Object)"Data is already immediately added");
    }

    public static interface Provider<P, A> {
        public void write(P var1, DataWriter var2, A var3, PluginConfig var4);
    }
}

