/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.transfer.simple;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerMeta;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface SimpleTransferHandler
extends TransferHandler,
TransferHandlerMeta {
    public static <C extends AbstractContainerMenu, D extends Display> SimpleTransferHandler create(final Class<? extends C> containerClass, final CategoryIdentifier<D> categoryIdentifier, final IntRange inputSlots) {
        return new SimpleTransferHandler(){

            @Override
            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                if (!containerClass.isInstance(context.getMenu()) || !categoryIdentifier.equals(context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                    return TransferHandler.ApplicabilityResult.createNotApplicable();
                }
                return TransferHandler.ApplicabilityResult.createApplicable();
            }

            @Override
            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                return IntStream.range(inputSlots.min, inputSlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().m_38853_(id))).toList();
            }

            @Override
            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                LocalPlayer player = context.getMinecraft().f_91074_;
                Inventory inventory = player.m_150109_();
                return IntStream.range(0, inventory.f_35974_.size()).mapToObj(index -> SlotAccessor.fromPlayerInventory((Player)player, index)).collect(Collectors.toList());
            }
        };
    }

    public static <C extends Container, D extends Display> SimpleTransferHandler create(final Class<? extends C> containerClass, final CategoryIdentifier<D> categoryIdentifier, final IntRange inputSlots, final IntRange inventorySlots) {
        return new SimpleTransferHandler(){

            @Override
            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                if (!containerClass.isInstance(context.getMenu()) || !categoryIdentifier.equals(context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                    return TransferHandler.ApplicabilityResult.createNotApplicable();
                }
                return TransferHandler.ApplicabilityResult.createApplicable();
            }

            @Override
            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                return IntStream.range(inputSlots.min, inputSlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().m_38853_(id))).toList();
            }

            @Override
            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                return IntStream.range(inventorySlots.min, inventorySlots.maxExclusive).mapToObj(id -> SlotAccessor.fromSlot(context.getMenu().m_38853_(id))).toList();
            }
        };
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context var1);

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context var1);

    default public List<InputIngredient<ItemStack>> getInputsIndexed(TransferHandler.Context context) {
        if (context.getDisplay() == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.map(context.getDisplay().getInputIngredients(context.getMenu(), (Player)context.getMinecraft().f_91074_), entry -> InputIngredient.withType(entry, VanillaEntryTypes.ITEM));
    }

    @Override
    default public Iterable<ItemStack> getAvailableIngredients(TransferHandler.Context context) {
        return Iterables.transform((Iterable)Iterables.concat(this.getInputSlots(context), this.getInventorySlots(context)), SlotAccessor::getItemStack);
    }

    default public void renderMissingInput(TransferHandler.Context context, List<InputIngredient<ItemStack>> inputs, List<InputIngredient<ItemStack>> missing, IntSet missingIndices, GuiGraphics graphics, int mouseX, int mouseY, float delta, List<Widget> widgets, Rectangle bounds) {
        int i = 0;
        for (Widget widget : widgets) {
            if (!(widget instanceof Slot) || ((Slot)widget).getNoticeMark() != 1 || !missingIndices.contains(i++)) continue;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
            Rectangle innerBounds = ((Slot)widget).getInnerBounds();
            graphics.m_280509_(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x40FF0000);
            graphics.m_280168_().m_85849_();
        }
    }

    default public MissingInputRenderer getMissingInputRenderer() {
        return this::renderMissingInput;
    }

    @Override
    default public TransferHandler.Result handle(TransferHandler.Context context) {
        return this.handleSimpleTransfer(context, this.getMissingInputRenderer(), this.getInputsIndexed(context), this.getInputSlots(context), this.getInventorySlots(context));
    }

    default public TransferHandler.Result handleSimpleTransfer(TransferHandler.Context context, MissingInputRenderer missingInputRenderer, List<InputIngredient<ItemStack>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        return ClientInternals.getSimpleTransferHandler().handle(context, missingInputRenderer, inputs, inputSlots, inventorySlots);
    }

    public record IntRange(int min, int maxExclusive) {
    }

    public static interface MissingInputRenderer {
        public void renderMissingInput(TransferHandler.Context var1, List<InputIngredient<ItemStack>> var2, List<InputIngredient<ItemStack>> var3, IntSet var4, GuiGraphics var5, int var6, int var7, float var8, List<Widget> var9, Rectangle var10);
    }
}

