/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsedEntriesBorderRenderer;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class ScrolledEntryListWidget
extends CollapsingEntryListWidget {
    private List<Object> stacks = new ArrayList<Object>();
    protected List<EntryListStackEntry> entries = Collections.emptyList();
    protected int blockedCount;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return ScrolledEntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return Mth.m_14167_((float)((float)(ScrolledEntryListWidget.this.stacks.size() + ScrolledEntryListWidget.this.blockedCount) / ((float)ScrolledEntryListWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };

    @Override
    protected void renderEntries(boolean fastEntryRendering, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        ScissorsHandler.INSTANCE.scissor(this.bounds);
        int entrySize = ScrolledEntryListWidget.entrySize();
        int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount() / (double)entrySize)));
        int nextIndex = skip * this.innerBounds.width / entrySize;
        this.blockedCount = 0;
        BatchedEntryRendererManager<EntryListStackEntry> helper = new BatchedEntryRendererManager<EntryListStackEntry>();
        Int2ObjectMap<CollapsedStack> indexedCollapsedStack = this.getCollapsedStackIndexed();
        int collapsedStacksIndex = 0;
        Object2IntOpenHashMap collapsedStackIndices = new Object2IntOpenHashMap();
        collapsedStackIndices.defaultReturnValue(-1);
        int i = nextIndex;
        for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
            EntryListStackEntry entry = this.entries.get(cont);
            Rectangle entryBounds = entry.getBounds();
            entryBounds.y = entry.backupY - this.scrolling.scrollAmountInt() - entryBounds.height / 2 + entrySize / 2;
            if (entryBounds.y > this.bounds.getMaxY() || this.stacks.size() <= i) break;
            if (ScrolledEntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height)) {
                CollapsedStack collapsedStack;
                Object stack = this.stacks.get(i++);
                entry.clearStacks();
                if (stack instanceof EntryStack) {
                    EntryStack entryStack = (EntryStack)stack;
                    if (!entryStack.isEmpty()) {
                        entry.entry(entryStack);
                        helper.add(entry);
                    }
                } else {
                    List ingredient = (List)stack;
                    if (!ingredient.isEmpty()) {
                        entry.entries((Collection)ingredient);
                        helper.addSlow(entry);
                    }
                }
                if ((collapsedStack = (CollapsedStack)indexedCollapsedStack.get(i - 1)) != null && collapsedStack.getIngredient().size() > 1) {
                    entry.collapsed(collapsedStack);
                    if (collapsedStackIndices.containsKey((Object)collapsedStack)) continue;
                    collapsedStackIndices.put((Object)collapsedStack, collapsedStacksIndex++);
                    continue;
                }
                entry.collapsed(null);
                continue;
            }
            ++this.blockedCount;
        }
        helper.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, graphics, mouseX, mouseY, delta);
        new CollapsedEntriesBorderRenderer().render(graphics, helper, (Object2IntMap<CollapsedStack>)collapsedStackIndices);
        this.scrolling.updatePosition(delta);
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.scrolling.getMaxScroll() > 0) {
            this.scrolling.renderScrollBar(graphics, 0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        }
    }

    @Override
    protected void updateEntries(int entrySize, boolean zoomed) {
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.stacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add((EntryListStackEntry)new EntryListStackEntry(this, xPos, yPos, entrySize, zoomed).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsChecked(mouseX, mouseY, false) && !Screen.m_96637_()) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.hasSpace() && this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public List<Object> getStacks() {
        return this.stacks;
    }

    @Override
    public void setStacks(List<Object> stacks) {
        this.stacks = stacks;
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount() / (double)ScrolledEntryListWidget.entrySize())));
        int nextIndex = skip * this.innerBounds.width / ScrolledEntryListWidget.entrySize();
        return this.entries.stream().skip(nextIndex).filter(entry -> entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter((Predicate<EntryStack>)Predicates.not(EntryStack::isEmpty));
    }

    @Override
    protected List<EntryListStackEntry> getEntryWidgets() {
        return this.entries;
    }
}

