/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.motors.extension;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.newage.content.motors.extension.MotorExtensionScrollValueBehaviour;
import org.antarcticgardens.newage.content.motors.extension.variants.IMotorExtensionVariant;

public class MotorExtensionBlockEntity
extends SmartBlockEntity {
    private MotorExtensionScrollValueBehaviour stressBehavior;
    private float multiplier = 1.0f;
    private final IMotorExtensionVariant variant;

    public MotorExtensionBlockEntity(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3, IMotorExtensionVariant variant) {
        super(arg, arg2, arg3);
        this.variant = variant;
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorExtensionBlockEntity> create(IMotorExtensionVariant variant) {
        return (type, pos, state) -> new MotorExtensionBlockEntity(type, pos, state, variant);
    }

    public void tick() {
        super.tick();
        if (this.multiplier > this.variant.getMultiplier()) {
            this.multiplier = this.variant.getMultiplier();
            this.stressBehavior.setValue((int)(this.multiplier * 100.0f));
        }
        this.stressBehavior.step = this.variant.getScrollStep();
        this.stressBehavior.betweenValidated(1, (int)(100.0f * this.variant.getMultiplier()));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.stressBehavior = new MotorExtensionScrollValueBehaviour((Component)CreateLang.translateDirect((String)"new_age.motor.stress_multiplier", (Object[])new Object[0]), this, (ValueBoxTransform)new MotorValueBox(), 1);
        this.stressBehavior.value = 100;
        this.stressBehavior.withCallback(i -> {
            this.multiplier = (float)i.intValue() / 100.0f;
            this.stressBehavior.value = i;
            this.notifyUpdate();
        });
        behaviours.add((BlockEntityBehaviour)this.stressBehavior);
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public IMotorExtensionVariant getVariant() {
        return this.variant;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.multiplier = compound.m_128457_("stressMultiplier");
        this.stressBehavior.value = (int)this.multiplier * 100;
        super.read(compound, clientPacket);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("stressMultiplier", this.multiplier);
        super.write(compound, clientPacket);
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)CreativeMotorBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

