/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.vec.Cuboid6;
import java.util.List;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SimpleGateTile;
import mrtjp.projectred.fabrication.engine.gates.TimedStateGateTile;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SimpleTimedStateGateTile
extends TimedStateGateTile {
    public SimpleTimedStateGateTile(ICGateTileType gateType) {
        super(gateType);
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        SimpleGateTile.addDeadSidesInteractions(zones, this.interactMask(), this::getBoundsForIOToggleZone, this::toggleDeadSide, this::getDeadSideToolTip);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Component getDeadSideToolTip(int r) {
        boolean isEnabled = (this.getShape() & this.rotationToDeadSideBit(r)) == 0;
        return Component.m_237115_((String)(isEnabled ? "projectred_fabrication.interact.side_enabled" : "projectred_fabrication.interact.side_disabled")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY);
    }

    protected Cuboid6 getBoundsForIOToggleZone(int r) {
        return SimpleGateTile.ZONE_BOUNDS[this.getRotation() << 2 | r];
    }

    protected void toggleDeadSide(int r) {
        if (this.getDeadSides() == 0) {
            return;
        }
        int oldShape = this.getShape();
        int shape = oldShape ^ this.rotationToDeadSideBit(r);
        if (Integer.bitCount(shape) > this.getMaxDeadSides()) {
            return;
        }
        this.configureShapeAndSend(shape);
    }

    protected int interactMask() {
        return 0;
    }

    protected int getDeadSides() {
        return 0;
    }

    protected int getMaxDeadSides() {
        return this.getDeadSides() - 1;
    }

    protected int rotationToDeadSideBit(int r) {
        return 1 << r - 1;
    }
}

